/*
 * Copyright 2004-2010 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.util;

import static org.junit.Assert.*;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.junit.Test;
import org.seasar.framework.util.ResourceUtil;

public class ExcelUtilTest {

    /**
     * TODO for azusa
     * 
     * @throws Exception
     *             例外が発生した場合
     */
    @Test
    public void 文字列のセル() throws Exception {
        HSSFWorkbook workbook = ExcelUtil.createWorkbook(ResourceUtil
                .getResourceAsStream("org/seasar/codegen/util/Excel.xls"));
        HSSFCell cell = ExcelUtil.getCell(workbook.getSheetAt(0), 0, 0);
        assertEquals("文字列", ExcelUtil.getString(cell));
    }

    @Test
    public void 数値のセル() throws Exception {
        HSSFWorkbook workbook = ExcelUtil.createWorkbook(ResourceUtil
                .getResourceAsStream("org/seasar/codegen/util/Excel.xls"));
        HSSFCell cell = ExcelUtil.getCell(workbook.getSheetAt(0), 0, 1);
        assertEquals("999", ExcelUtil.getString(cell));
    }

    @Test
    public void 真偽値のセル() throws Exception {
        HSSFWorkbook workbook = ExcelUtil.createWorkbook(ResourceUtil
                .getResourceAsStream("org/seasar/codegen/util/Excel.xls"));
        HSSFCell cell = ExcelUtil.getCell(workbook.getSheetAt(0), 0, 2);
        assertEquals("true", ExcelUtil.getString(cell));
    }
}
