/*
 * Copyright 2004-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.impl;

import static org.junit.Assert.*;

import org.junit.Test;
import org.seasar.codegen.element.lang.JavaDataType;

public class JavaDataTypeSelectHelperImplTest {

    private JavaDataTypeSelectHelperImpl target = new JavaDataTypeSelectHelperImpl();

    @Test
    public void null不許可でデフォルト値未設定の時はデフォルト値が設定されている() throws Exception {
        JavaDataType type = (JavaDataType) target.getDataType("String", true,
                "");
        assertEquals("\"\"", type.getDefVal());
    }

    @Test
    public void null不許可でデフォルト値設定の時はデフォルト値が設定される() throws Exception {
        JavaDataType type = (JavaDataType) target.getDataType("String", true,
                "default");
        assertEquals("\"default\"", type.getDefVal());
    }

    @Test
    public void null許可でデフォルト値未設定の時はデフォルト値が設定されている() throws Exception {
        JavaDataType type = (JavaDataType) target.getDataType("String", false,
                "");
        assertEquals("", type.getDefVal());
    }

    @Test
    public void null許可でデフォルト値設定の時はデフォルト値が設定されている() throws Exception {
        JavaDataType type = (JavaDataType) target.getDataType("String", false,
                "default");
        assertEquals("\"default\"", type.getDefVal());
    }
}
