/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.impl;

import java.io.File;
import java.util.List;
import java.util.Map;

import org.seasar.codegen.CodeGenConfig;
import org.seasar.codegen.ImportCodeData;
import org.seasar.codegen.element.Field;
import org.seasar.codegen.element.Table;
import org.seasar.extension.unit.S2TestCase;

public class ERWinCSVImportCodeDataTest extends S2TestCase {
    private String PATH = "org/seasar/codegen/impl/ERWinCSV.dicon";

    private ImportCodeData importCodeData_;

    private CodeGenConfig codeGenConfig;

    public ERWinCSVImportCodeDataTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        include(PATH);
    }

    public void testCSVImport() {
        File src = new File("test/forautogenarate.csv");
        Map<String, Table> datas = importCodeData_.readCodeData(src);
        assertEquals(datas.size(), 5);
        System.out.println(datas);
    }

    public void testSetupPrimaryKey_identity() {
        ERWinCSVImportCodeData importCodeData = new ERWinCSVImportCodeData() {
            @Override
            boolean hasPrimaryKey(List<String> oneLine) {
                return true;
            }
        };
        ((CodeGenConfigImpl) codeGenConfig).setIdentityType("identity");
        importCodeData.setCodeGenConfig(codeGenConfig);
        Field field = new Field();
        Table table = new Table();
        importCodeData.setupPrimaryKey(null, field, table);
        assertTrue(field.isUseIdentity());
    }

    public void testSetupPrimaryKey_sequence() {
        ERWinCSVImportCodeData importCodeData = new ERWinCSVImportCodeData() {
            @Override
            boolean hasPrimaryKey(List<String> oneLine) {
                return true;
            }
        };
        ((CodeGenConfigImpl) codeGenConfig).setIdentityType("sequence");
        importCodeData.setCodeGenConfig(codeGenConfig);
        Field field = new Field();
        field.setFieldName("column");
        Table table = new Table();
        importCodeData.setupPrimaryKey(null, field, table);
        assertTrue(field.isUseSequence());
        assertEquals("column", field.getSequence());
    }

    public void testSetupPrimaryKey_assingned() {
        ERWinCSVImportCodeData importCodeData = new ERWinCSVImportCodeData() {
            @Override
            boolean hasPrimaryKey(List<String> oneLine) {
                return true;
            }
        };
        ((CodeGenConfigImpl) codeGenConfig).setIdentityType(null);
        importCodeData.setCodeGenConfig(codeGenConfig);
        Field field = new Field();
        field.setFieldName("column");
        Table table = new Table();
        importCodeData.setupPrimaryKey(null, field, table);
        assertFalse(field.isUseIdentity());
        assertNull(field.getSequence());
        assertFalse(table.getPrimaryKey().isEmpty());
    }
}
