/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.ant;

import java.io.File;

import org.seasar.codegen.ImportCodeData;
import org.seasar.codegen.OutputCode;
import org.seasar.codegen.impl.AbstractEntityOutputCodeImpl;
import org.seasar.framework.container.S2Container;

/**
 * 個別のリソースの出力先です。
 * 
 * @author azusa
 * 
 */
public class EachGen {

    private File destinationDir;

    private File csvFile;

    private S2Container container;

    private OutputCode outputCode;

    /**
     * 出力処理を行います。
     */
    public void generate() {
        ImportCodeData icd = (ImportCodeData) container
                .getComponent(ImportCodeData.class);
        // OutputCode oc = (OutputCode) s2.getComponent(OutputCode.class);
        AbstractEntityOutputCodeImpl oc = (AbstractEntityOutputCodeImpl) outputCode;
        oc.generateCode(this.destinationDir, icd.readCodeData(this.csvFile));
    }

    /**
     * 入力ファイルを設定します。
     * 
     * @param csvFile
     *            入力ファイル
     */
    public void setCsvFile(File csvFile) {
        this.csvFile = csvFile;
    }

    /**
     * 出力先を設定します。
     * 
     * @param destinationDir
     *            出力先
     */
    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    /**
     * S2コンテナを返します。
     * 
     * @return S2コンテナ
     */
    public S2Container getContainer() {
        return container;
    }

    /**
     * S2コンテナを設定します。
     * 
     * @param container
     *            S2コンテナ
     */
    public void setContainer(S2Container container) {
        this.container = container;
    }

    /**
     * 出力処理クラスを設定します。
     * 
     * @param outputCode
     *            出力処理クラス
     */
    public void setOutputCode(OutputCode outputCode) {
        this.outputCode = outputCode;
    }
}