/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.NotSingleRowUpdatedRuntimeException;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.UpdateHandler;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.impl.BasicHandler;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.IntegerConversionUtil;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.StatementUtil;

public abstract class AbstractAutoHandler
extends BasicHandler
implements UpdateHandler {
    private BeanMetaData beanMetaData;
    private Object[] bindVariables;
    private ValueType[] bindVariableValueTypes;
    private Timestamp timestamp;
    private Integer versionNo;
    private PropertyType[] propertyTypes;
    private boolean checkSingleRowUpdate;

    public AbstractAutoHandler(DataSource dataSource, StatementFactory statementFactory, BeanMetaData beanMetaData, PropertyType[] propertyTypes, boolean checkSingleRowUpdate) {
        this.setDataSource(dataSource);
        this.setStatementFactory(statementFactory);
        this.beanMetaData = beanMetaData;
        this.propertyTypes = propertyTypes;
        this.checkSingleRowUpdate = checkSingleRowUpdate;
    }

    public BeanMetaData getBeanMetaData() {
        return this.beanMetaData;
    }

    protected Logger getLogger() {
        return Logger.getLogger((Class)this.loggerClass);
    }

    protected Object[] getBindVariables() {
        return this.bindVariables;
    }

    protected void setBindVariables(Object[] bindVariables) {
        this.bindVariables = bindVariables;
    }

    protected ValueType[] getBindVariableValueTypes() {
        return this.bindVariableValueTypes;
    }

    protected void setBindVariableValueTypes(ValueType[] bindVariableValueTypes) {
        this.bindVariableValueTypes = bindVariableValueTypes;
    }

    protected Timestamp getTimestamp() {
        return this.timestamp;
    }

    protected void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    protected Integer getVersionNo() {
        return this.versionNo;
    }

    protected void setVersionNo(Integer versionNo) {
        this.versionNo = versionNo;
    }

    protected PropertyType[] getPropertyTypes() {
        return this.propertyTypes;
    }

    protected void setPropertyTypes(PropertyType[] propertyTypes) {
        this.propertyTypes = propertyTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Object[] args) throws SQLRuntimeException {
        Connection connection = this.getConnection();
        try {
            int n = this.execute(connection, args[0]);
            return n;
        }
        finally {
            ConnectionUtil.close((Connection)connection);
        }
    }

    public int execute(Object[] args, Class[] argTypes) throws SQLRuntimeException {
        return this.execute(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int execute(Connection connection, Object bean) {
        this.preUpdateBean(bean);
        this.setupBindVariables(bean);
        this.logSql(this.bindVariables, this.getArgTypes(this.bindVariables));
        PreparedStatement ps = this.prepareStatement(connection);
        int ret = -1;
        try {
            this.bindArgs(ps, this.bindVariables, this.bindVariableValueTypes);
            ret = PreparedStatementUtil.executeUpdate((PreparedStatement)ps);
        }
        finally {
            StatementUtil.close((Statement)ps);
        }
        if (this.checkSingleRowUpdate && ret != 1) {
            throw new NotSingleRowUpdatedRuntimeException(bean, ret);
        }
        this.postUpdateBean(bean);
        return ret;
    }

    protected void bindArgs(PreparedStatement ps, Object[] args, ValueType[] valueTypes) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            ValueType valueType = valueTypes[i];
            try {
                valueType.bindValue(ps, i + 1, args[i]);
                continue;
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
        }
    }

    protected void preUpdateBean(Object bean) {
    }

    protected void postUpdateBean(Object bean) {
    }

    protected abstract void setupBindVariables(Object var1);

    protected void setupInsertBindVariables(Object bean) {
        ArrayList<Object> varList = new ArrayList<Object>();
        ArrayList<ValueType> varValueTypeList = new ArrayList<ValueType>();
        BeanMetaData bmd = this.getBeanMetaData();
        String timestampPropertyName = bmd.getTimestampPropertyName();
        String versionNoPropertyName = bmd.getVersionNoPropertyName();
        for (int i = 0; i < this.propertyTypes.length; ++i) {
            PropertyType pt = this.propertyTypes[i];
            if (pt.getPropertyName().equalsIgnoreCase(timestampPropertyName)) {
                this.setTimestamp(new Timestamp(new Date().getTime()));
                varList.add(this.getTimestamp());
            } else if (pt.getPropertyName().equals(versionNoPropertyName)) {
                this.setVersionNo(new Integer(0));
                varList.add(this.getVersionNo());
            } else {
                varList.add(pt.getPropertyDesc().getValue(bean));
            }
            varValueTypeList.add(pt.getValueType());
        }
        this.setBindVariables(varList.toArray());
        this.setBindVariableValueTypes(varValueTypeList.toArray(new ValueType[varValueTypeList.size()]));
    }

    protected void setupUpdateBindVariables(Object bean) {
        ArrayList<Object> varList = new ArrayList<Object>();
        ArrayList<ValueType> varValueTypeList = new ArrayList<ValueType>();
        BeanMetaData bmd = this.getBeanMetaData();
        String timestampPropertyName = bmd.getTimestampPropertyName();
        String versionNoPropertyName = bmd.getVersionNoPropertyName();
        for (int i = 0; i < this.propertyTypes.length; ++i) {
            PropertyType pt = this.propertyTypes[i];
            if (pt.getPropertyName().equalsIgnoreCase(timestampPropertyName)) {
                this.setTimestamp(new Timestamp(new Date().getTime()));
                varList.add(this.getTimestamp());
            } else if (pt.getPropertyName().equals(versionNoPropertyName)) {
                Object value = pt.getPropertyDesc().getValue(bean);
                int intValue = IntegerConversionUtil.toPrimitiveInt((Object)value) + 1;
                this.setVersionNo(new Integer(intValue));
                varList.add(this.getVersionNo());
            } else {
                varList.add(pt.getPropertyDesc().getValue(bean));
            }
            varValueTypeList.add(pt.getValueType());
        }
        this.addAutoUpdateWhereBindVariables(varList, varValueTypeList, bean);
        this.setBindVariables(varList.toArray());
        this.setBindVariableValueTypes(varValueTypeList.toArray(new ValueType[varValueTypeList.size()]));
    }

    protected void setupDeleteBindVariables(Object bean) {
        ArrayList varList = new ArrayList();
        ArrayList varValueTypeList = new ArrayList();
        this.addAutoUpdateWhereBindVariables(varList, varValueTypeList, bean);
        this.setBindVariables(varList.toArray());
        this.setBindVariableValueTypes(varValueTypeList.toArray(new ValueType[varValueTypeList.size()]));
    }

    protected void addAutoUpdateWhereBindVariables(List varList, List varValueTypeList, Object bean) {
        PropertyDesc pd;
        BeanMetaData bmd = this.getBeanMetaData();
        for (int i = 0; i < bmd.getPrimaryKeySize(); ++i) {
            PropertyType pt = bmd.getPropertyTypeByColumnName(bmd.getPrimaryKey(i));
            PropertyDesc pd2 = pt.getPropertyDesc();
            varList.add(pd2.getValue(bean));
            varValueTypeList.add(pt.getValueType());
        }
        if (bmd.hasVersionNoPropertyType()) {
            PropertyType pt = bmd.getVersionNoPropertyType();
            pd = pt.getPropertyDesc();
            varList.add(pd.getValue(bean));
            varValueTypeList.add(pt.getValueType());
        }
        if (bmd.hasTimestampPropertyType()) {
            PropertyType pt = bmd.getTimestampPropertyType();
            pd = pt.getPropertyDesc();
            varList.add(pd.getValue(bean));
            varValueTypeList.add(pt.getValueType());
        }
    }

    protected void updateTimestampIfNeed(Object bean) {
        if (this.getTimestamp() != null) {
            PropertyDesc pd = this.getBeanMetaData().getTimestampPropertyType().getPropertyDesc();
            pd.setValue(bean, (Object)this.getTimestamp());
        }
    }

    protected void updateVersionNoIfNeed(Object bean) {
        if (this.getVersionNo() != null) {
            PropertyDesc pd = this.getBeanMetaData().getVersionNoPropertyType().getPropertyDesc();
            pd.setValue(bean, (Object)this.getVersionNo());
        }
    }
}

