/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.validator.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jiemamy.JiemamyContext;
import org.jiemamy.model.DbObject;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.validator.AbstractProblem;
import org.jiemamy.validator.AbstractValidator;
import org.jiemamy.validator.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyclicForeignReferenceValidator
extends AbstractValidator {
    public Collection<Problem> validate(JiemamyContext context) {
        ArrayList problems = Lists.newArrayListWithCapacity((int)1);
        for (JmTable table : context.getTables()) {
            Set<DbObject> superNonRecursives = context.findSuperDbObjectsNonRecursive(table);
            for (DbObject superNonRecursive : superNonRecursives) {
                Set<DbObject> superRecursive;
                if (superNonRecursive.equals(table) || !(superRecursive = context.findSuperDbObjectsRecursive(superNonRecursive)).contains(table)) continue;
                problems.add(new CyclicForeignReferenceProblem(table));
                return problems;
            }
        }
        return problems;
    }

    static class CyclicForeignReferenceProblem
    extends AbstractProblem {
        CyclicForeignReferenceProblem(JmTable table) {
            super(table, "F0230", new Object[]{table.getId().toString()});
        }
    }
}

