/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils;

import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyContext;
import org.jiemamy.model.DbObject;
import org.jiemamy.model.SimpleDbObject;
import org.jiemamy.model.domain.JmDomain;
import org.jiemamy.model.index.JmIndex;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.model.view.JmView;

public final class NamingUtil {
    public static void autoName(SimpleDbObject target, JiemamyContext context) {
        Validate.notNull((Object)target);
        Validate.notNull((Object)context);
        StringBuilder sb = new StringBuilder();
        int counter = 0;
        boolean duplicated = true;
        block0: while (duplicated) {
            if (target instanceof JmTable) {
                sb.append("TABLE_");
            } else if (target instanceof JmView) {
                sb.append("VIEW_");
            } else if (target instanceof JmDomain) {
                sb.append("DOMAIN_");
            } else if (target instanceof JmIndex) {
                sb.append("INDEX_");
            } else {
                throw new IllegalArgumentException("Unknown target: " + target.getClass().toString());
            }
            sb.append(++counter);
            duplicated = false;
            for (DbObject dbObject : context.getDbObjects()) {
                if (!sb.toString().equals(dbObject.getName())) continue;
                duplicated = true;
                sb.setLength(0);
                continue block0;
            }
        }
        target.setName(sb.toString());
    }

    private NamingUtil() {
    }
}

