/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.serializer.stax;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyContext;
import org.jiemamy.JiemamyContextStaxHandler;
import org.jiemamy.JiemamyFacet;
import org.jiemamy.SimpleJmMetadata;
import org.jiemamy.SimpleJmMetadataStaxHandler;
import org.jiemamy.model.column.SimpleJmColumn;
import org.jiemamy.model.column.SimpleJmColumnStaxHandler;
import org.jiemamy.model.constraint.SimpleJmCheckConstraint;
import org.jiemamy.model.constraint.SimpleJmCheckConstraintStaxHandler;
import org.jiemamy.model.constraint.SimpleJmDeferrability;
import org.jiemamy.model.constraint.SimpleJmDeferrabilityStaxHandler;
import org.jiemamy.model.constraint.SimpleJmForeignKeyConstraint;
import org.jiemamy.model.constraint.SimpleJmForeignKeyConstraintStaxHandler;
import org.jiemamy.model.constraint.SimpleJmNotNullConstraint;
import org.jiemamy.model.constraint.SimpleJmNotNullConstraintStaxHandler;
import org.jiemamy.model.constraint.SimpleJmPrimaryKeyConstraint;
import org.jiemamy.model.constraint.SimpleJmPrimaryKeyConstraintStaxHandler;
import org.jiemamy.model.constraint.SimpleJmUniqueKeyConstraint;
import org.jiemamy.model.constraint.SimpleJmUniqueKeyConstraintStaxHandler;
import org.jiemamy.model.dataset.SimpleJmDataSet;
import org.jiemamy.model.dataset.SimpleJmDataSetStaxHandler;
import org.jiemamy.model.dataset.SimpleJmRecord;
import org.jiemamy.model.dataset.SimpleJmRecordStaxHandler;
import org.jiemamy.model.datatype.SimpleDataType;
import org.jiemamy.model.datatype.SimpleDataTypeStaxHandler;
import org.jiemamy.model.datatype.SimpleRawTypeDescriptor;
import org.jiemamy.model.datatype.SimpleRawTypeDescriptorStaxHandler;
import org.jiemamy.model.table.SimpleJmTable;
import org.jiemamy.model.table.SimpleJmTableStaxHandler;
import org.jiemamy.model.view.SimpleJmView;
import org.jiemamy.model.view.SimpleJmViewStaxHandler;
import org.jiemamy.serializer.SerializationException;
import org.jiemamy.serializer.stax.DeserializationContext;
import org.jiemamy.serializer.stax.DummyHandler;
import org.jiemamy.serializer.stax.JiemamyCursor;
import org.jiemamy.serializer.stax.SerializationContext;
import org.jiemamy.serializer.stax.StaxHandler;
import org.jiemamy.xml.CoreQName;
import org.jiemamy.xml.JiemamyQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaxDirector {
    private static Logger logger = LoggerFactory.getLogger(StaxDirector.class);
    final Map<String, StaxHandler<?>> handlersWithFqcnKey = Maps.newHashMap();
    final Map<QName, StaxHandler<?>> handlersWithQNameKey = Maps.newHashMap();
    final DummyHandler dummy;

    public StaxDirector(JiemamyContext context) {
        Validate.notNull((Object)context);
        this.dummy = new DummyHandler(this);
        this.addHandler(JiemamyContext.class, CoreQName.JIEMAMY, new JiemamyContextStaxHandler(this));
        this.addHandler(SimpleJmMetadata.class, CoreQName.META, new SimpleJmMetadataStaxHandler(this));
        this.addHandler(SimpleJmView.class, CoreQName.VIEW, new SimpleJmViewStaxHandler(this));
        this.addHandler(SimpleJmTable.class, CoreQName.TABLE, new SimpleJmTableStaxHandler(this));
        this.addHandler(SimpleJmColumn.class, CoreQName.COLUMN, new SimpleJmColumnStaxHandler(this));
        this.addHandler(SimpleDataType.class, CoreQName.DATA_TYPE, new SimpleDataTypeStaxHandler(this));
        this.addHandler(SimpleRawTypeDescriptor.class, CoreQName.TYPE_DESC, new SimpleRawTypeDescriptorStaxHandler(this));
        this.addHandler(SimpleJmNotNullConstraint.class, CoreQName.NOT_NULL, new SimpleJmNotNullConstraintStaxHandler(this));
        this.addHandler(SimpleJmPrimaryKeyConstraint.class, CoreQName.PRIMARY_KEY, new SimpleJmPrimaryKeyConstraintStaxHandler(this));
        this.addHandler(SimpleJmForeignKeyConstraint.class, CoreQName.FOREIGN_KEY, new SimpleJmForeignKeyConstraintStaxHandler(this));
        this.addHandler(SimpleJmUniqueKeyConstraint.class, CoreQName.UNIQUE_KEY, new SimpleJmUniqueKeyConstraintStaxHandler(this));
        this.addHandler(SimpleJmCheckConstraint.class, CoreQName.CHECK, new SimpleJmCheckConstraintStaxHandler(this));
        this.addHandler(SimpleJmDeferrability.class, CoreQName.DEFERRABILITY, new SimpleJmDeferrabilityStaxHandler(this));
        this.addHandler(SimpleJmDataSet.class, CoreQName.DATASET, new SimpleJmDataSetStaxHandler(this));
        this.addHandler(SimpleJmRecord.class, CoreQName.RECORDS, new SimpleJmRecordStaxHandler(this));
        for (JiemamyFacet jiemamyFacet : context.getFacets()) {
            jiemamyFacet.prepareStaxHandlers(this);
        }
    }

    public <T> void addHandler(Class<T> clazz, JiemamyQName jQName, StaxHandler<T> handler) {
        Validate.notNull(clazz);
        Validate.notNull((Object)jQName);
        Validate.notNull(handler);
        this.handlersWithFqcnKey.put(clazz.getName(), handler);
        this.handlersWithQNameKey.put(jQName.getQName(), handler);
    }

    public <T> T direct(DeserializationContext dctx) throws SerializationException {
        Validate.notNull((Object)dctx);
        StaxHandler<JiemamyCursor> handler = this.findHandler((T)dctx.peek());
        return (T)handler.handleDeserialization(dctx);
    }

    public <T> void direct(T target, SerializationContext sctx) throws SerializationException {
        Validate.notNull(target);
        Validate.notNull((Object)sctx);
        StaxHandler<T> handler = this.findHandler(target);
        handler.handleSerialization(target, sctx);
    }

    private <T> StaxHandler<T> findHandler(JiemamyCursor cursor) throws SerializationException {
        Validate.notNull((Object)cursor);
        try {
            QName qName = cursor.getQName();
            if (cursor.hasAttr(CoreQName.CLASS)) {
                String className = cursor.getAttrValue(CoreQName.CLASS);
                return this.findHandler((T)className);
            }
            DummyHandler handler = this.handlersWithQNameKey.get(qName);
            if (handler == null) {
                logger.warn("can not found deserialization handler : " + qName);
                handler = this.dummy;
            }
            return handler;
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }

    private <T> StaxHandler<T> findHandler(String targetName) {
        Validate.notNull((Object)targetName);
        DummyHandler handler = this.handlersWithFqcnKey.get(targetName);
        if (handler == null) {
            logger.warn("can not found serialization handler : " + targetName);
            handler = this.dummy;
        }
        return handler;
    }

    private <T> StaxHandler<T> findHandler(T target) {
        Validate.notNull(target);
        return this.findHandler((T)target.getClass().getName());
    }
}

