/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.constraint;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.jiemamy.dddbase.AbstractEntity;
import org.jiemamy.dddbase.DefaultEntityRef;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.model.constraint.JmConstraint;
import org.jiemamy.model.constraint.JmDeferrability;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.model.table.TableNotFoundException;
import org.jiemamy.model.table.TooManyTablesFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleJmConstraint
extends AbstractEntity
implements JmConstraint {
    private String name;
    private String logicalName;
    private String description;
    private JmDeferrability deferrability;

    public SimpleJmConstraint(UUID id) {
        super(id);
    }

    @Override
    public SimpleJmConstraint clone() {
        SimpleJmConstraint clone = (SimpleJmConstraint)super.clone();
        return clone;
    }

    @Override
    public JmTable findDeclaringTable(Iterable<? extends JmTable> tables) {
        Validate.notNull(tables);
        Iterable c = Iterables.filter(tables, (Predicate)new Predicate<JmTable>(){

            public boolean apply(JmTable table) {
                Validate.notNull((Object)table);
                return table.getConstraints().contains(SimpleJmConstraint.this);
            }
        });
        try {
            return (JmTable)Iterables.getOnlyElement((Iterable)c);
        }
        catch (NoSuchElementException e) {
            throw new TableNotFoundException("contains " + this + " in " + tables);
        }
        catch (IllegalArgumentException e) {
            throw new TooManyTablesFoundException(c);
        }
    }

    @Override
    public JmDeferrability getDeferrability() {
        return this.deferrability;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLogicalName() {
        return this.logicalName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setDeferrability(JmDeferrability deferrability) {
        this.deferrability = deferrability;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLogicalName(String logicalName) {
        this.logicalName = logicalName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EntityRef<? extends SimpleJmConstraint> toReference() {
        return new DefaultEntityRef((Entity)this);
    }

    public String toString() {
        return super.toString() + "{name=" + this.name + "}";
    }
}

