/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy;

import org.apache.commons.lang.Validate;

public class Version {
    static final Version INSTANCE = new Version(0, 3, 0, false);
    private final int major;
    private final int minor;
    private final int release;
    private final boolean snapshot;

    public static Version parse(String versionString) {
        int major = 0;
        int minor = 0;
        int release = 0;
        boolean snapshot = false;
        if (versionString.endsWith("-SNAPSHOT")) {
            snapshot = true;
            versionString = versionString.substring(0, versionString.length() - "-SNAPSHOT".length());
        }
        String[] elements = versionString.split("[\\.]");
        try {
            switch (elements.length) {
                case 3: {
                    release = Integer.parseInt(elements[2]);
                }
                case 2: {
                    major = Integer.parseInt(elements[0]);
                    minor = Integer.parseInt(elements[1]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(versionString);
                }
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(versionString, e);
        }
        return new Version(major, minor, release, snapshot);
    }

    Version(int major, int minor, int release, boolean snapshot) {
        this.major = major;
        this.minor = minor;
        this.release = release;
        this.snapshot = snapshot;
    }

    public boolean canDeserialize(Version target) {
        Validate.notNull((Object)target);
        if (this.major != target.getMajor()) {
            return false;
        }
        return this.minor >= target.getMinor();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!Version.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        Version other = (Version)obj;
        if (this.major != other.getMajor()) {
            return false;
        }
        if (this.minor != other.getMinor()) {
            return false;
        }
        if (this.release != other.getRelease()) {
            return false;
        }
        return this.snapshot == other.isSnapshot();
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRelease() {
        return this.release;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.release;
        result = 31 * result + (this.snapshot ? 1231 : 1237);
        return result;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major);
        sb.append(".");
        sb.append(this.minor);
        sb.append(".");
        sb.append(this.release);
        if (this.snapshot) {
            sb.append("-SNAPSHOT");
        }
        return sb.toString();
    }

    public String toStringSpec() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major);
        sb.append(".");
        sb.append(this.minor);
        return sb.toString();
    }
}

