/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.dao;

import java.util.List;

import org.seasar.codegen.sample.entity.BuriState;
import org.seasar.codegen.sample.condition.BuriStateCondition;
import org.seasar.codegen.sample.entity.BuriStateRelation;
import org.seasar.codegen.sample.condition.BuriStateRelationCondition;
/**
 * BuriStateテーブルに対応するDaoの中核部分です。
 * このDaoはgeneration gapを使用しているので、処理を追加するときはBuriStateDaoに処理を記述します。
 * @author S2Dao-CodeGen
 */
@org.seasar.dao.annotation.tiger.S2Dao(bean = BuriState.class)
@org.seasar.codegen.lib.annotation.SqlFileEncoding("UTF-8")
public interface BuriStateCore {

	/**
	 * BuriStateのEntityを全て取得します。主キーが複合主キーでない場合は主キーでソートします。
	 *
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Query("ORDER BY StateID")
	public List<BuriState> getAllBuriState();


	/**
	 * 引数が主キーと一致するBuriStateのEntityを取得します。
	 *
	 * @param StateID 主キー
	 * @return Entity。一致しない場合は<code>null</code>
	 */
	@org.seasar.dao.annotation.tiger.Query("StateID = ?")
	public BuriState getBuriState(Long StateID);


	/**
	 * 引数が主キーと一致するBuriStateのEntityのリストを主キーでソートして取得します。
	 *
	 * @param stateIDs  主キーの配列
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Arguments("StateIDs")
	@org.seasar.dao.annotation.tiger.Query("StateID in /*stateIDs*/(1) ORDER BY StateID")
	public List<BuriState> getBuriStateByIds(Long ... stateIDs);
	

	/**
	 * Conditionに指定した検索条件と一致するEntityのリストを取得します。
	 *
	 * @param dto 検索条件を指定したCondition
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Arguments("condition")
	public List<BuriState> find(BuriStateCondition condition);

	/**
	 * Conditionに指定した検索条件と一致するEntityを取得します。
	 *
	 * @param dto 検索条件を指定したFindDto
	 * @return Entityに対応するDto。一致しない場合は<code>null</code>
	 * @throws org.seasar.dao.NotSingleResultRuntimeException 結果が2件以上だった場合
	 */
	public BuriState soleMatch(BuriStateCondition condition);


	/**
	 * BuriStateのEntityを関連先も含めて全て取得します。主キーが複合主キーでない場合は主キーでソートします。
	 *
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Query("ORDER BY StateID")
	public List<BuriStateRelation> getAllBuriStateWithRelation();


	/**
	 * 引数が主キーと一致するBuriStateのEntityを関連先も含めて取得します。
	 *
	 * @param StateID 主キー
	 * @return Entity。一致しない場合は<code>null</code>
	 */
	@org.seasar.dao.annotation.tiger.Query("StateID  = ? ORDER BY StateID")
	public BuriStateRelation getBuriStateWithRelation(Long stateID);


	/**
	 * 引数が主キーと一致するBuriStateのEntityのリストを関連先も含めて主キーでソートして取得します。
	 *
	 * @param stateIDs  主キーの配列
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Arguments("stateIDs")
	@org.seasar.dao.annotation.tiger.Query("StateID in /*stateIDs*/(1) ORDER BY StateID")
	public List<BuriStateRelation> getBuriStateByIdsWithRelation(Object ... stateIDs);
	
	/**
	 * Conditionに指定した検索条件と一致するEntityのリストを関連先も含めて取得します。
	 *
	 * @param condition 検索条件を指定したCondition
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Arguments("condition")
	public List<BuriStateRelation> findWithRelation(BuriStateRelationCondition condition);

	/**
	 * Conditionに指定した検索条件と一致するEntityを関連先も含めて取得します。
	 *
	 * @param condition 検索条件を指定したCondition
	 * @return Entityのリスト。一致しない場合は<code>null</code>
	 * @throws org.seasar.dao.NotSingleResultRuntimeException 結果が2件以上だった場合
	 */
	public BuriStateRelation soleMatchWithRelation(BuriStateRelationCondition condition);
	/**
	 * Entityを追加します。
	 *
	 * @param entity 追加するEntity
	 */
	public void insert(BuriState entity);
	/**
	 * Entityを更新します。
	 *
	 * @param entity 更新するEntity
	 * @throws org.seasar.dao.NotSingleRowUpdatedRuntimeException 更新結果が0件の場合
	 */
	public void update(BuriState entity);

	/**
	 * Entityを削除します。
	 *
	 * @param entity 削除するEntity
	 * @throws org.seasar.dao.NotSingleRowUpdatedRuntimeException 更新結果が0件の場合
	 */
	public void delete(BuriState entity);

	/**
	 * Entityのプロパティのうち、setterが呼ばれたプロパティのみを更新します.	 
	 *
	 * @param entity 更新するEntity
	 * @throws org.seasar.dao.NotSingleRowUpdatedRuntimeException 更新結果が0件の場合
	 */
	public void updateModifiedOnly(BuriState entity);

	/**
	 * Entityを更新します。このメソッドは更新結果が0件の時例外を投げません。
	 * @param entity Entity
	 * @return 更新結果の件数
	 */
	 @org.seasar.dao.annotation.tiger.CheckSingleRowUpdate(false)
	 public int updateNonCheck(BuriState entity);

	/**
	 * Entityのプロパティのうち、setterが呼ばれたプロパティのみを更新します。このメソッドは更新結果が0件の時例外を返しません。
	 * @param entity Entity
	 * @return 更新結果の件数
	 */
	@org.seasar.dao.annotation.tiger.CheckSingleRowUpdate(false)
	public int updateNonCheckModifiedOnly(BuriState entity);
	/**
	 * 追加をバッチ更新で行います。
	 * @param entityList 追加するEntityのリスト
	 * @return 更新カウントの配列。
	 */
	 public int[] insertBatch(List<BuriState> entityList);
	/**
	 * 更新をバッチ更新で行います。
	 * @param entityList 更新するEntityのリスト
	 * @return 更新カウントの配列。
	 */
	 public int[] updateBatch(List<BuriState> entityList);

	/**
	 * 削除をバッチ更新で行います。
	 * @param EntityList 削除するEntityのリスト
	 * @return 更新カウントの配列。
	 */
	 public int[] deleteBatch(List<BuriState> entityList);

}

