/*
 * Copyright 2004-2010 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.impl.exception;

import static org.junit.Assert.*;

import java.io.File;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.seasar.codegen.ImportCodeData;
import org.seasar.codegen.exception.NotTypeMatchException;
import org.seasar.framework.unit.Seasar2;

@RunWith(Seasar2.class)
public class ERWinCSVImportCodeDataTest {

    private ImportCodeData importCodeData;

    @Test
    public void NotTypeMatchExceptionが発生した場合() throws Exception {
        try {
            importCodeData.readCodeData(new File("test/forautogenarate.csv"));
            fail();
        } catch (NotTypeMatchException e) {
            System.out.println(e.getMessage());
            assertTrue(true);
        }
    }
}
