/*
 * Copyright 2004-2010 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.exception;

import static org.junit.Assert.*;

import org.junit.Test;
import org.seasar.codegen.dbms.DB2;
import org.seasar.codegen.dbms.Dbms;
import org.seasar.codegen.unit.util.FieldSettingUtil;

public class NotTypeMatchExceptionTest {

    private Dbms target = new DB2();

    @Test
    public void testNotTypeMatchException() {
        try {
            target.selectBestDataType(FieldSettingUtil.createFieldSetting(
                    "AAA", "true"));

        } catch (InternalGenerateException e) {
            assertEquals("AAA", e.getTypeName());
        }
    }

    @Test
    public void ネストしたタイプ例外の場合のメッセージ出力() {
        Exception e = new NotTypeMatchException("table", "column",
                new InternalGenerateException("type"));
        assertEquals(
                "[ECDG0005]サポートされていないタイプです。(テーブル:table カラム:column タイプ:type)よろしかったら、http://s2dao-codegen.sandbox.seasar.org/docs/report.htmlまでご報告ください。",
                e.getMessage());
    }
}
