/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dddbase;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.Validate;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dddbase.EntityNotFoundException;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.dddbase.EntityResolver;
import org.jiemamy.dddbase.utils.CloneUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OnMemoryEntityResolver<T extends Entity>
implements EntityResolver,
Cloneable {
    private Map<UUID, T> storage = new ConcurrentHashMap<UUID, T>();

    private static Map<UUID, Entity> collectAll(Entity entity, Map<UUID, Entity> collector) {
        collector.put(entity.getId(), entity);
        for (Entity entity2 : entity.getSubEntities()) {
            OnMemoryEntityResolver.collectAll(entity2, collector);
        }
        return collector;
    }

    private static Map<UUID, Entity> getAll(Iterable<? extends Entity> entities, Map<UUID, Entity> collector) {
        for (Entity entity : entities) {
            OnMemoryEntityResolver.collectAll(entity, collector);
        }
        return collector;
    }

    public OnMemoryEntityResolver<T> clone() {
        try {
            OnMemoryEntityResolver clone = (OnMemoryEntityResolver)super.clone();
            clone.storage = CloneUtil.cloneEntityConcurrentHashMap(this.storage);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("clone not supported", e);
        }
    }

    @Override
    public boolean contains(EntityRef<?> ref) {
        Validate.notNull(ref);
        return this.contains(ref.getReferentId());
    }

    @Override
    public boolean contains(UUID id) {
        Validate.notNull((Object)id);
        return OnMemoryEntityResolver.getAll(this.storage.values(), new HashMap<UUID, Entity>()).containsKey(id);
    }

    @Override
    public <E extends Entity> E resolve(EntityRef<E> ref) {
        Validate.notNull(ref);
        return (E)this.resolve(ref.getReferentId());
    }

    @Override
    public Entity resolve(UUID id) {
        Validate.notNull((Object)id);
        Map<UUID, Entity> map = OnMemoryEntityResolver.getAll(CloneUtil.cloneEntityArrayList(this.storage.values()), new HashMap<UUID, Entity>());
        if (!map.containsKey(id)) {
            throw new EntityNotFoundException("id=" + id);
        }
        return map.get(id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ClassUtils.getShortClassName(this.getClass()));
        sb.append("@ih=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(this.storage.values().toString());
        return sb.toString();
    }

    protected Map<UUID, T> getStorage() {
        return this.storage;
    }
}

