/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;

public class CSVWriter {
    private Writer rawWriter;
    private PrintWriter pw;
    private char separator;
    private char quotechar;
    public static final char ESCAPE_CHARACTER = '\"';
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';

    public CSVWriter(Writer writer) {
        this(writer, ',');
    }

    public CSVWriter(Writer writer, char c) {
        this(writer, c, '\"');
    }

    public CSVWriter(Writer writer, char c, char c2) {
        this.rawWriter = writer;
        this.pw = new PrintWriter(writer);
        this.separator = c;
        this.quotechar = c2;
    }

    public void writeAll(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String[] stringArray = (String[])iterator.next();
            this.writeNext(stringArray);
        }
    }

    public void writeNext(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (i != 0) {
                stringBuffer.append(this.separator);
            }
            if ((string = stringArray[i]) == null) continue;
            stringBuffer.append(this.quotechar);
            for (int j = 0; j < string.length(); ++j) {
                char c = string.charAt(j);
                if (c == this.quotechar) {
                    stringBuffer.append('\"').append(c);
                    continue;
                }
                if (c == '\"') {
                    stringBuffer.append('\"').append(c);
                    continue;
                }
                stringBuffer.append(c);
            }
            stringBuffer.append(this.quotechar);
        }
        stringBuffer.append('\n');
        this.pw.write(stringBuffer.toString());
    }

    public void close() throws IOException {
        this.pw.flush();
        this.pw.close();
        this.rawWriter.close();
    }
}

