/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.Dbms;
import org.seasar.dao.IdentifierGenerator;
import org.seasar.dao.NoPersistentPropertyTypeRuntimeException;
import org.seasar.dao.RelationPropertyType;
import org.seasar.dao.RelationPropertyTypeFactory;
import org.seasar.dao.TableNaming;
import org.seasar.dao.id.IdentifierGeneratorFactory;
import org.seasar.dao.impl.DtoMetaDataImpl;
import org.seasar.extension.jdbc.ColumnNotFoundRuntimeException;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.PropertyNotFoundRuntimeException;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.CaseInsensitiveMap;
import org.seasar.framework.util.ClassUtil;

public class BeanMetaDataImpl
extends DtoMetaDataImpl
implements BeanMetaData {
    private String tableName;
    private Map propertyTypesByColumnName = new CaseInsensitiveMap();
    private List relationPropertyTypes = new ArrayList();
    private PropertyType[] primaryKeys;
    private String autoSelectList;
    private List identifierGenerators = new ArrayList();
    private Map identifierGeneratorsByPropertyName = new HashMap();
    private String versionNoPropertyName;
    private String timestampPropertyName;
    private Dbms dbms;
    private ModifiedPropertySupport modifiedPropertySupport;
    private TableNaming tableNaming;
    private RelationPropertyTypeFactory relationPropertyTypeFactory;

    public void initialize() {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)this.getBeanClass());
        this.setupTableName(beanDesc);
        this.setupProperty();
        this.setupPrimaryKey();
    }

    public void setDbms(Dbms dbms) {
        this.dbms = dbms;
    }

    public String getTableName() {
        return this.tableName;
    }

    public PropertyType getVersionNoPropertyType() throws PropertyNotFoundRuntimeException {
        return this.getPropertyType(this.getVersionNoPropertyName());
    }

    public PropertyType getTimestampPropertyType() throws PropertyNotFoundRuntimeException {
        return this.getPropertyType(this.getTimestampPropertyName());
    }

    public String getVersionNoPropertyName() {
        return this.versionNoPropertyName;
    }

    public void setVersionNoPropertyName(String versionNoPropertyName) {
        this.versionNoPropertyName = versionNoPropertyName;
    }

    public String getTimestampPropertyName() {
        return this.timestampPropertyName;
    }

    public void setTimestampPropertyName(String timestampPropertyName) {
        this.timestampPropertyName = timestampPropertyName;
    }

    public PropertyType getPropertyTypeByColumnName(String columnName) throws ColumnNotFoundRuntimeException {
        PropertyType propertyType = (PropertyType)this.propertyTypesByColumnName.get(columnName);
        if (propertyType == null) {
            throw new ColumnNotFoundRuntimeException(this.tableName, columnName);
        }
        return propertyType;
    }

    public PropertyType getPropertyTypeByAliasName(String alias) {
        if (this.hasPropertyTypeByColumnName(alias)) {
            return this.getPropertyTypeByColumnName(alias);
        }
        int index = alias.lastIndexOf(95);
        if (index < 0) {
            throw new ColumnNotFoundRuntimeException(this.tableName, alias);
        }
        String columnName = alias.substring(0, index);
        String relnoStr = alias.substring(index + 1);
        int relno = -1;
        try {
            relno = Integer.parseInt(relnoStr);
        }
        catch (Throwable t) {
            throw new ColumnNotFoundRuntimeException(this.tableName, alias);
        }
        RelationPropertyType rpt = this.getRelationPropertyType(relno);
        if (!rpt.getBeanMetaData().hasPropertyTypeByColumnName(columnName)) {
            throw new ColumnNotFoundRuntimeException(this.tableName, alias);
        }
        return rpt.getBeanMetaData().getPropertyTypeByColumnName(columnName);
    }

    public boolean hasPropertyTypeByColumnName(String columnName) {
        return this.propertyTypesByColumnName.get(columnName) != null;
    }

    public boolean hasPropertyTypeByAliasName(String alias) {
        if (this.hasPropertyTypeByColumnName(alias)) {
            return true;
        }
        int index = alias.lastIndexOf(95);
        if (index < 0) {
            return false;
        }
        String columnName = alias.substring(0, index);
        String relnoStr = alias.substring(index + 1);
        int relno = -1;
        try {
            relno = Integer.parseInt(relnoStr);
        }
        catch (Throwable t) {
            return false;
        }
        if (relno >= this.getRelationPropertyTypeSize()) {
            return false;
        }
        RelationPropertyType rpt = this.getRelationPropertyType(relno);
        return rpt.getBeanMetaData().hasPropertyTypeByColumnName(columnName);
    }

    public boolean hasVersionNoPropertyType() {
        return this.hasPropertyType(this.getVersionNoPropertyName());
    }

    public boolean hasTimestampPropertyType() {
        return this.hasPropertyType(this.getTimestampPropertyName());
    }

    public String convertFullColumnName(String alias) {
        if (this.hasPropertyTypeByColumnName(alias)) {
            return this.tableName + "." + alias;
        }
        int index = alias.lastIndexOf(95);
        if (index < 0) {
            throw new ColumnNotFoundRuntimeException(this.tableName, alias);
        }
        String columnName = alias.substring(0, index);
        String relnoStr = alias.substring(index + 1);
        int relno = -1;
        try {
            relno = Integer.parseInt(relnoStr);
        }
        catch (Throwable t) {
            throw new ColumnNotFoundRuntimeException(this.tableName, alias);
        }
        RelationPropertyType rpt = this.getRelationPropertyType(relno);
        if (!rpt.getBeanMetaData().hasPropertyTypeByColumnName(columnName)) {
            throw new ColumnNotFoundRuntimeException(this.tableName, alias);
        }
        return rpt.getPropertyName() + "." + columnName;
    }

    public int getRelationPropertyTypeSize() {
        return this.relationPropertyTypes.size();
    }

    public RelationPropertyType getRelationPropertyType(int index) {
        return (RelationPropertyType)this.relationPropertyTypes.get(index);
    }

    public RelationPropertyType getRelationPropertyType(String propertyName) throws PropertyNotFoundRuntimeException {
        for (int i = 0; i < this.getRelationPropertyTypeSize(); ++i) {
            RelationPropertyType rpt = (RelationPropertyType)this.relationPropertyTypes.get(i);
            if (rpt == null || !rpt.getPropertyName().equalsIgnoreCase(propertyName)) continue;
            return rpt;
        }
        throw new PropertyNotFoundRuntimeException(this.getBeanClass(), propertyName);
    }

    protected void setupTableName(BeanDesc beanDesc) {
        String ta = this.beanAnnotationReader.getTableAnnotation();
        this.tableName = ta != null ? ta : this.tableNaming.fromEntityNameToTableName(ClassUtil.getShortClassName((Class)beanDesc.getBeanClass()));
    }

    protected void setupProperty() {
        PropertyType[] propertyTypes = this.propertyTypeFactory.createBeanPropertyTypes(this.tableName);
        for (int i = 0; i < propertyTypes.length; ++i) {
            PropertyType pt = propertyTypes[i];
            this.addPropertyType(pt);
            this.propertyTypesByColumnName.put(pt.getColumnName(), pt);
        }
        RelationPropertyType[] relationPropertyTypes = this.relationPropertyTypeFactory.createRelationPropertyTypes();
        for (int i = 0; i < relationPropertyTypes.length; ++i) {
            RelationPropertyType rpt = relationPropertyTypes[i];
            this.addRelationPropertyType(rpt);
        }
    }

    protected void setupPrimaryKey() {
        ArrayList<PropertyType> keys = new ArrayList<PropertyType>();
        for (int i = 0; i < this.getPropertyTypeSize(); ++i) {
            PropertyType pt = this.getPropertyType(i);
            if (!pt.isPrimaryKey()) continue;
            keys.add(pt);
            this.setupIdentifierGenerator(pt);
        }
        this.primaryKeys = keys.toArray(new PropertyType[keys.size()]);
    }

    protected void setupIdentifierGenerator(PropertyType propertyType) {
        PropertyDesc pd = propertyType.getPropertyDesc();
        String propertyName = propertyType.getPropertyName();
        String idType = this.beanAnnotationReader.getId(pd, this.dbms);
        IdentifierGenerator generator = IdentifierGeneratorFactory.createIdentifierGenerator(propertyType, this.dbms, idType);
        this.identifierGenerators.add(generator);
        this.identifierGeneratorsByPropertyName.put(propertyName, generator);
    }

    protected void addRelationPropertyType(RelationPropertyType rpt) {
        for (int i = this.relationPropertyTypes.size(); i <= rpt.getRelationNo(); ++i) {
            this.relationPropertyTypes.add(null);
        }
        this.relationPropertyTypes.set(rpt.getRelationNo(), rpt);
    }

    public int getPrimaryKeySize() {
        return this.primaryKeys.length;
    }

    public String getPrimaryKey(int index) {
        return this.primaryKeys[index].getColumnName();
    }

    public int getIdentifierGeneratorSize() {
        return this.identifierGenerators.size();
    }

    public IdentifierGenerator getIdentifierGenerator(int index) {
        return (IdentifierGenerator)this.identifierGenerators.get(index);
    }

    public IdentifierGenerator getIdentifierGenerator(String propertyName) {
        return (IdentifierGenerator)this.identifierGeneratorsByPropertyName.get(propertyName);
    }

    public synchronized String getAutoSelectList() {
        if (this.autoSelectList != null) {
            return this.autoSelectList;
        }
        this.setupAutoSelectList();
        return this.autoSelectList;
    }

    protected void setupAutoSelectList() {
        int i;
        StringBuffer buf = new StringBuffer(100);
        buf.append("SELECT ");
        boolean first = true;
        for (i = 0; i < this.getPropertyTypeSize(); ++i) {
            PropertyType pt = this.getPropertyType(i);
            if (!pt.isPersistent()) continue;
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(this.tableName);
            buf.append(".");
            buf.append(pt.getColumnName());
        }
        for (i = 0; i < this.getRelationPropertyTypeSize(); ++i) {
            RelationPropertyType rpt = this.getRelationPropertyType(i);
            BeanMetaData bmd = rpt.getBeanMetaData();
            for (int j = 0; j < bmd.getPropertyTypeSize(); ++j) {
                PropertyType pt = bmd.getPropertyType(j);
                if (!pt.isPersistent()) continue;
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                String columnName = pt.getColumnName();
                buf.append(rpt.getPropertyName());
                buf.append(".");
                buf.append(columnName);
                buf.append(" AS ");
                buf.append(columnName).append("_").append(rpt.getRelationNo());
            }
        }
        if (first) {
            throw new NoPersistentPropertyTypeRuntimeException();
        }
        this.autoSelectList = buf.toString();
    }

    public ModifiedPropertySupport getModifiedPropertySupport() {
        return this.modifiedPropertySupport;
    }

    public void setModifiedPropertySupport(ModifiedPropertySupport propertyModifiedSupport) {
        this.modifiedPropertySupport = propertyModifiedSupport;
    }

    public Set getModifiedPropertyNames(Object bean) {
        return this.getModifiedPropertySupport().getModifiedPropertyNames(bean);
    }

    public TableNaming getTableNaming() {
        return this.tableNaming;
    }

    public void setTableNaming(TableNaming tableNaming) {
        this.tableNaming = tableNaming;
    }

    public void setRelationPropertyTypeFactory(RelationPropertyTypeFactory relationPropertyTypeFactory) {
        this.relationPropertyTypeFactory = relationPropertyTypeFactory;
    }

    public static interface ModifiedPropertySupport {
        public Set getModifiedPropertyNames(Object var1);
    }
}

