/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.util.ArrayList;
import javax.sql.DataSource;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.IdentifierGenerator;
import org.seasar.dao.PrimaryKeyNotFoundRuntimeException;
import org.seasar.dao.impl.AbstractAutoHandler;
import org.seasar.dao.impl.AbstractStaticCommand;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.framework.exception.SRuntimeException;

public abstract class AbstractAutoStaticCommand
extends AbstractStaticCommand {
    private PropertyType[] propertyTypes;
    private boolean checkSingleRowUpdate = true;

    public AbstractAutoStaticCommand(DataSource dataSource, StatementFactory statementFactory, BeanMetaData beanMetaData, String[] propertyNames) {
        super(dataSource, statementFactory, beanMetaData);
        this.setupPropertyTypes(propertyNames);
        this.setupSql();
    }

    public Object execute(Object[] args) {
        AbstractAutoHandler handler = this.createAutoHandler();
        handler.setSql(this.getSql());
        this.injectDaoClass(handler);
        int rows = handler.execute(args);
        return new Integer(rows);
    }

    public boolean isCheckSingleRowUpdate() {
        return this.checkSingleRowUpdate;
    }

    public void setCheckSingleRowUpdate(boolean checkSingleRowUpdate) {
        this.checkSingleRowUpdate = checkSingleRowUpdate;
    }

    protected PropertyType[] getPropertyTypes() {
        return this.propertyTypes;
    }

    protected void setPropertyTypes(PropertyType[] propertyTypes) {
        this.propertyTypes = propertyTypes;
    }

    protected abstract AbstractAutoHandler createAutoHandler();

    protected abstract void setupPropertyTypes(String[] var1);

    protected void setupInsertPropertyTypes(String[] propertyNames) {
        ArrayList<PropertyType> types = new ArrayList<PropertyType>();
        for (int i = 0; i < propertyNames.length; ++i) {
            PropertyType pt = this.getBeanMetaData().getPropertyType(propertyNames[i]);
            if (!this.isInsertTarget(pt)) continue;
            types.add(pt);
        }
        this.propertyTypes = types.toArray(new PropertyType[types.size()]);
    }

    protected boolean isInsertTarget(PropertyType propertyType) {
        if (propertyType.isPrimaryKey()) {
            String name = propertyType.getPropertyName();
            IdentifierGenerator generator = this.getBeanMetaData().getIdentifierGenerator(name);
            return generator.isSelfGenerate();
        }
        return true;
    }

    protected void setupUpdatePropertyTypes(String[] propertyNames) {
        if (propertyNames.length == 0) {
            throw new SRuntimeException("EDAO0035");
        }
        ArrayList<PropertyType> types = new ArrayList<PropertyType>();
        for (int i = 0; i < propertyNames.length; ++i) {
            PropertyType pt = this.getBeanMetaData().getPropertyType(propertyNames[i]);
            if (pt.isPrimaryKey()) continue;
            types.add(pt);
        }
        if (types.size() == 0) {
            throw new SRuntimeException("EDAO0020");
        }
        this.propertyTypes = types.toArray(new PropertyType[types.size()]);
    }

    protected void setupDeletePropertyTypes(String[] propertyNames) {
    }

    protected abstract void setupSql();

    protected void setupInsertSql() {
        PropertyType pt;
        int i;
        BeanMetaData bmd = this.getBeanMetaData();
        StringBuffer buf = new StringBuffer(100);
        buf.append("INSERT INTO ");
        buf.append(bmd.getTableName());
        buf.append(" (");
        for (i = 0; i < this.propertyTypes.length; ++i) {
            pt = this.propertyTypes[i];
            if (!this.isInsertTarget(pt)) continue;
            buf.append(pt.getColumnName());
            buf.append(", ");
        }
        buf.setLength(buf.length() - 2);
        buf.append(") VALUES (");
        for (i = 0; i < this.propertyTypes.length; ++i) {
            pt = this.propertyTypes[i];
            if (!this.isInsertTarget(pt)) continue;
            buf.append("?, ");
        }
        buf.setLength(buf.length() - 2);
        buf.append(")");
        this.setSql(buf.toString());
    }

    protected void setupUpdateSql() {
        this.checkPrimaryKey();
        StringBuffer buf = new StringBuffer(100);
        buf.append("UPDATE ");
        buf.append(this.getBeanMetaData().getTableName());
        buf.append(" SET ");
        for (int i = 0; i < this.propertyTypes.length; ++i) {
            PropertyType pt = this.propertyTypes[i];
            buf.append(pt.getColumnName());
            buf.append(" = ?, ");
        }
        buf.setLength(buf.length() - 2);
        this.setupUpdateWhere(buf);
        this.setSql(buf.toString());
    }

    protected void setupDeleteSql() {
        this.checkPrimaryKey();
        StringBuffer buf = new StringBuffer(100);
        buf.append("DELETE FROM ");
        buf.append(this.getBeanMetaData().getTableName());
        this.setupUpdateWhere(buf);
        this.setSql(buf.toString());
    }

    protected void checkPrimaryKey() {
        BeanMetaData bmd = this.getBeanMetaData();
        if (bmd.getPrimaryKeySize() == 0) {
            throw new PrimaryKeyNotFoundRuntimeException(bmd.getBeanClass());
        }
    }

    protected void setupUpdateWhere(StringBuffer buf) {
        BeanMetaData bmd = this.getBeanMetaData();
        buf.append(" WHERE ");
        for (int i = 0; i < bmd.getPrimaryKeySize(); ++i) {
            buf.append(bmd.getPrimaryKey(i));
            buf.append(" = ? AND ");
        }
        buf.setLength(buf.length() - 5);
        if (bmd.hasVersionNoPropertyType()) {
            PropertyType pt = bmd.getVersionNoPropertyType();
            buf.append(" AND ");
            buf.append(pt.getColumnName());
            buf.append(" = ?");
        }
        if (bmd.hasTimestampPropertyType()) {
            PropertyType pt = bmd.getTimestampPropertyType();
            buf.append(" AND ");
            buf.append(pt.getColumnName());
            buf.append(" = ?");
        }
    }
}

