/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.DividePtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.NumericOperationEval;
import org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEvalToNumericXlator;

public class DivideEval
extends NumericOperationEval {
    private DividePtg delegate;
    private static final ValueEvalToNumericXlator NUM_XLATOR = new ValueEvalToNumericXlator(219);

    public DivideEval(Ptg ptg) {
        this.delegate = (DividePtg)ptg;
    }

    protected ValueEvalToNumericXlator getXlator() {
        return NUM_XLATOR;
    }

    public Eval evaluate(Eval[] operands, int srcRow, short srcCol) {
        ErrorEval retval = null;
        double d0 = 0.0;
        double d1 = 0.0;
        switch (operands.length) {
            default: {
                retval = ErrorEval.UNKNOWN_ERROR;
                break;
            }
            case 2: {
                ValueEval ve = this.singleOperandEvaluate(operands[0], srcRow, srcCol);
                if (ve instanceof NumericValueEval) {
                    d0 = ((NumericValueEval)ve).getNumberValue();
                } else if (!(ve instanceof BlankEval)) {
                    retval = ErrorEval.VALUE_INVALID;
                }
                if (retval != null) break;
                ve = this.singleOperandEvaluate(operands[1], srcRow, srcCol);
                if (ve instanceof NumericValueEval) {
                    d1 = ((NumericValueEval)ve).getNumberValue();
                    break;
                }
                if (ve instanceof BlankEval) break;
                retval = ErrorEval.VALUE_INVALID;
            }
        }
        if (retval == null) {
            retval = d1 == 0.0 ? ErrorEval.DIV_ZERO : (Double.isNaN(d0) || Double.isNaN(d1) ? ErrorEval.VALUE_INVALID : new NumberEval(d0 / d1));
        }
        return retval;
    }

    public int getNumberOfOperands() {
        return this.delegate.getNumberOfOperands();
    }

    public int getType() {
        return this.delegate.getType();
    }
}

