/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.jiemamy.utils.TraversalHandlerException;

public final class ResourceTraversal {
    public static void forEach(File rootDir, ResourceHandler handler) throws IOException, TraversalHandlerException {
        ResourceTraversal.forEach(rootDir, null, handler);
    }

    public static void forEach(File rootDir, String baseDirectory, ResourceHandler handler) throws IOException, TraversalHandlerException {
        Validate.notNull((Object)rootDir);
        Validate.notNull((Object)handler);
        File baseDir = ResourceTraversal.getBaseDir(rootDir, baseDirectory);
        if (baseDir.exists()) {
            ResourceTraversal.traverseFileSystem(rootDir, baseDir, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forEach(JarFile jarFile, ResourceHandler handler) throws IOException, TraversalHandlerException {
        Validate.notNull((Object)jarFile);
        Validate.notNull((Object)handler);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry entry = enumeration.nextElement();
            if (entry.isDirectory()) continue;
            String entryName = entry.getName().replace('\\', '/');
            InputStream is = jarFile.getInputStream(entry);
            try {
                handler.processResource(entryName, is);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    private static File getBaseDir(File rootDir, String baseDirectory) {
        File baseDir = rootDir;
        if (baseDirectory != null) {
            String[] names;
            for (String name : names = baseDirectory.split("/")) {
                baseDir = new File(baseDir, name);
            }
        }
        return baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traverseFileSystem(File rootDir, File baseDir, ResourceHandler handler) throws IOException, TraversalHandlerException {
        File[] files = baseDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                ResourceTraversal.traverseFileSystem(rootDir, file, handler);
                continue;
            }
            int pos = rootDir.getCanonicalPath().length();
            String filePath = file.getCanonicalPath();
            String resourcePath = filePath.substring(pos + 1).replace('\\', '/');
            FileInputStream is = new FileInputStream(file);
            try {
                handler.processResource(resourcePath, is);
                continue;
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    private ResourceTraversal() {
    }

    public static interface ResourceHandler {
        public void processResource(String var1, InputStream var2) throws TraversalHandlerException;
    }
}

