/*
 * Copyright 2006-2010 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package org.seasar.codegen.maven.condition;

import org.seasar.codegen.lib.Condition;
import org.seasar.codegen.lib.ConditionResult;
import org.seasar.codegen.lib.impl.ColumnImpl;
import org.seasar.codegen.lib.impl.ConditionResultImpl;
import org.seasar.dao.pager.DefaultPagerCondition;

/**
 * EMP_TABLEテーブルに対する検索条件です。
 * @author S2Dao-CodeGen
 */
public class EmpTableCondition extends DefaultPagerCondition implements Condition {

	private static final long serialVersionUID = 1L;

	private String alias;

	protected ConditionResult conditionResult;

	/**
	 * コンストラクタです。
	 * 
	 * @param alias 表の別名
	 * @param conditionResult 検索条件
	 */
	EmpTableCondition(ConditionResult conditionResult,String alias) {
		this.alias = alias;
		this.conditionResult = conditionResult;
	}

	/**
	 * コンストラクタです。表の別名はテーブル名になります。
	 */
	public EmpTableCondition() {
		this.alias = "EMP_TABLE";
		this.conditionResult = new ConditionResultImpl();
	}

	public ConditionResult getConditionResult() {
		return conditionResult;
	}


	/**
	 * 社員番号の検索条件を返します。
	 * @return 社員番号の検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<Integer> selectEmpNo() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<Integer>(conditionResult, new ColumnImpl(this.alias,"EMP_NO", getClass()));
	}


	/**
	 * 社員名の検索条件を返します。
	 * @return 社員名の検索条件
	 */
	public org.seasar.codegen.lib.impl.StringConditionElementImpl<String> selectEname() {
		return new org.seasar.codegen.lib.impl.StringConditionElementImpl<String>(conditionResult, new ColumnImpl(this.alias,"ENAME", getClass()));
	}


	/**
	 * 職種の検索条件を返します。
	 * @return 職種の検索条件
	 */
	public org.seasar.codegen.lib.impl.StringConditionElementImpl<String> selectJob() {
		return new org.seasar.codegen.lib.impl.StringConditionElementImpl<String>(conditionResult, new ColumnImpl(this.alias,"JOB", getClass()));
	}


	/**
	 *  上司の検索条件を返します。
	 * @return  上司の検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<Integer> selectMgr() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<Integer>(conditionResult, new ColumnImpl(this.alias,"MGR", getClass()));
	}


	/**
	 * 入社日の検索条件を返します。
	 * @return 入社日の検索条件
	 */
	public org.seasar.codegen.lib.impl.DateConditionElementImpl<java.util.Date> selectHireDate() {
		return new org.seasar.codegen.lib.impl.DateConditionElementImpl<java.util.Date>(conditionResult, new ColumnImpl(this.alias,"HIRE_DATE", getClass()));
	}


	/**
	 * 給料の検索条件を返します。
	 * @return 給料の検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<java.math.BigDecimal> selectSal() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<java.math.BigDecimal>(conditionResult, new ColumnImpl(this.alias,"SAL", getClass()));
	}


	/**
	 * 歩合給の検索条件を返します。
	 * @return 歩合給の検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<java.math.BigDecimal> selectComm() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<java.math.BigDecimal>(conditionResult, new ColumnImpl(this.alias,"COMM", getClass()));
	}


	/**
	 * 部署番号の検索条件を返します。
	 * @return 部署番号の検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<Integer> selectDeptNo() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<Integer>(conditionResult, new ColumnImpl(this.alias,"DEPT_NO", getClass()));
	}


	/**
	 * タイムスタンプの検索条件を返します。
	 * @return タイムスタンプの検索条件
	 */
	public org.seasar.codegen.lib.impl.DateConditionElementImpl<java.sql.Timestamp> selectTstamp() {
		return new org.seasar.codegen.lib.impl.DateConditionElementImpl<java.sql.Timestamp>(conditionResult, new ColumnImpl(this.alias,"TSTAMP", getClass()));
	}


	/**
	 * バージョン番号の検索条件を返します。
	 * @return バージョン番号の検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<Integer> selectVersionno() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<Integer>(conditionResult, new ColumnImpl(this.alias,"VERSIONNO", getClass()));
	}



	public void addQuery(String query, Object... args) {
		conditionResult.addQuery(query, args);
	}

	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append(conditionResult.toString());
		sb.append("/offset=");
		sb.append(getOffset());
		sb.append("/limit=");
		sb.append(getLimit());
		return sb.toString();
	}

}
