/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class CSVReader {
    private BufferedReader br;
    private boolean hasNext = true;
    private char separator;
    private char quotechar;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';

    public CSVReader(Reader reader) {
        this(reader, ',');
    }

    public CSVReader(Reader reader, char c) {
        this(reader, c, '\"');
    }

    public CSVReader(Reader reader, char c, char c2) {
        this.br = new BufferedReader(reader);
        this.separator = c;
        this.quotechar = c2;
    }

    public List readAll() throws IOException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        while (this.hasNext) {
            String[] stringArray = this.readNext();
            if (stringArray == null) continue;
            arrayList.add(stringArray);
        }
        return arrayList;
    }

    public String[] readNext() throws IOException {
        String string = this.getNextLine();
        return this.hasNext ? this.parseLine(string) : null;
    }

    private String getNextLine() throws IOException {
        String string = this.br.readLine();
        if (string == null) {
            this.hasNext = false;
        }
        return this.hasNext ? string : null;
    }

    private String[] parseLine(String string) throws IOException {
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        do {
            if (bl) {
                stringBuffer.append("\n");
                string = this.getNextLine();
                if (string == null) break;
            }
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == this.quotechar) {
                    if (bl && string.length() > i + 1 && string.charAt(i + 1) == this.quotechar) {
                        stringBuffer.append(string.charAt(i + 1));
                        ++i;
                        continue;
                    }
                    bl = !bl;
                    continue;
                }
                if (c == this.separator && !bl) {
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                    continue;
                }
                stringBuffer.append(c);
            }
        } while (bl);
        arrayList.add(stringBuffer.toString());
        return arrayList.toArray(new String[0]);
    }

    public void close() throws IOException {
        this.br.close();
    }
}

