/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.view;

import java.util.Map;
import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.Validate;
import org.codehaus.staxmate.in.SMEvent;
import org.jiemamy.model.parameter.ParameterMap;
import org.jiemamy.model.view.SimpleJmView;
import org.jiemamy.serializer.SerializationException;
import org.jiemamy.serializer.stax.DeserializationContext;
import org.jiemamy.serializer.stax.JiemamyCursor;
import org.jiemamy.serializer.stax.JiemamyOutputContainer;
import org.jiemamy.serializer.stax.JiemamyOutputElement;
import org.jiemamy.serializer.stax.SerializationContext;
import org.jiemamy.serializer.stax.StaxDirector;
import org.jiemamy.serializer.stax.StaxHandler;
import org.jiemamy.xml.CoreQName;
import org.jiemamy.xml.JiemamyQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleJmViewStaxHandler
extends StaxHandler<SimpleJmView> {
    private static Logger logger = LoggerFactory.getLogger(SimpleJmViewStaxHandler.class);

    public SimpleJmViewStaxHandler(StaxDirector director) {
        super(director);
    }

    @Override
    public SimpleJmView handleDeserialization(DeserializationContext dctx) throws SerializationException {
        Validate.notNull((Object)dctx);
        try {
            Validate.isTrue((dctx.peek().getCurrEvent() == SMEvent.START_ELEMENT ? 1 : 0) != 0);
            Validate.isTrue((boolean)dctx.peek().isQName(CoreQName.VIEW));
            JiemamyCursor cursor = dctx.peek();
            String idString = cursor.getAttrValue(CoreQName.ID);
            UUID id = dctx.getContext().toUUID(idString);
            SimpleJmView view = new SimpleJmView(id);
            JiemamyCursor childCursor = cursor.childElementCursor();
            dctx.push(childCursor);
            do {
                childCursor.advance();
                if (childCursor.getCurrEvent() == SMEvent.START_ELEMENT) {
                    if (childCursor.isQName(CoreQName.NAME)) {
                        view.setName(childCursor.collectDescendantText(false));
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.LOGICAL_NAME)) {
                        view.setLogicalName(childCursor.collectDescendantText(false));
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.DESCRIPTION)) {
                        view.setDescription(childCursor.collectDescendantText(false));
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.DEFINITION)) {
                        view.setDefinition(childCursor.collectDescendantText(false));
                        continue;
                    }
                    logger.warn("UNKNOWN ELEMENT: {}", (Object)childCursor.getQName().toString());
                    continue;
                }
                if (childCursor.getCurrEvent() == null) continue;
                logger.warn("UNKNOWN EVENT: {}", (Object)childCursor.getCurrEvent());
            } while (childCursor.getCurrEvent() != null);
            dctx.pop();
            return view;
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void handleSerialization(SimpleJmView model, SerializationContext sctx) throws SerializationException {
        Validate.notNull((Object)model);
        Validate.notNull((Object)sctx);
        JiemamyOutputContainer parent = sctx.peek();
        try {
            JiemamyOutputElement element = parent.addElement(CoreQName.VIEW);
            element.addAttribute((JiemamyQName)CoreQName.ID, model.getId());
            element.addElementAndCharacters((JiemamyQName)CoreQName.NAME, model.getName());
            element.addElementAndCharacters((JiemamyQName)CoreQName.LOGICAL_NAME, model.getLogicalName());
            element.addElementAndCharacters((JiemamyQName)CoreQName.DESCRIPTION, model.getDescription());
            element.addElementAndCharacters((JiemamyQName)CoreQName.DEFINITION, model.getDefinition());
            ParameterMap params = model.getParams();
            if (params.size() > 0) {
                JiemamyOutputElement paramesElement = element.addElement(CoreQName.PARAMETERS);
                for (Map.Entry<String, String> entry : params) {
                    JiemamyOutputElement paramElement = paramesElement.addElement(CoreQName.PARAMETER);
                    paramElement.addAttribute((JiemamyQName)CoreQName.PARAMETER_KEY, entry.getKey());
                    paramElement.addCharacters(entry.getValue());
                }
            }
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }
}

