/*
 * Decompiled with CFR 0.152.
 */
package jp.starlogic.servicemanager.abst;

import java.util.Calendar;
import jp.starlogic.servicemanager.abst.AbstractGetRunService;
import jp.starlogic.util.datetime.DateUtil;
import jp.starlogic.util.datetime.UtilCalendar;

public abstract class AbstractCronTypeService
extends AbstractGetRunService {
    private UtilCalendar lastRun = null;
    private UtilCalendar nextRun = null;

    public void initService() {
        this.nextRunUpdate();
    }

    public boolean canService() {
        if (this.nextRun == null) {
            return false;
        }
        return DateUtil.compare(UtilCalendar.getInstance(), (Calendar)this.nextRun) >= 0L;
    }

    public void execute() {
        this.executeCron();
        this.lastRun = this.nextRun;
        this.nextRun = null;
        this.nextRunUpdate();
    }

    protected abstract void executeCron();

    public void nextRunUpdate() {
        if (this.lastRun == null) {
            this.lastRun = (UtilCalendar)UtilCalendar.getInstance();
            this.lastRun.clearMilliSecond();
        }
        UtilCalendar argCalendar = (UtilCalendar)this.lastRun.clone();
        this.nextRun = this.createNextRunCalender(argCalendar);
    }

    protected abstract UtilCalendar createNextRunCalender(UtilCalendar var1);

    public UtilCalendar getLastRun() {
        return this.lastRun;
    }

    public void setLastRun(UtilCalendar lastRun) {
        this.lastRun = lastRun;
    }

    public UtilCalendar getNextRun() {
        return this.nextRun;
    }

    public void setNextRun(UtilCalendar nextRun) {
        this.nextRun = nextRun;
    }
}

