/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.lib.impl;

import java.util.List;

import junit.framework.TestCase;

import org.seasar.codegen.lib.BindValue;
import org.seasar.codegen.lib.ConditionResult;
import org.seasar.codegen.lib.Operator;

/**
 * @author azusa
 * 
 */
public class StringConditionElementImplTest extends TestCase {

    /**
     * 
     */
    private static final String COLUMN = "bbb";

    /**
     * 
     */
    private static final String ALIAS = "aaa";

    // private EmpTableCondition empCondition = new EmpTableCondition();

    private ConditionResult conditionResult = new ConditionResultImpl();

    private StringConditionElementImpl conditionElement = new StringConditionElementImpl(conditionResult,
            new ColumnImpl(ALIAS, COLUMN, null));

    /*
     * (非 Javadoc)
     * 
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * {@link org.seasar.codegen.lib.impl.StringConditionElementImpl#like(String)}
     * のためのテスト・メソッド。
     */
    public void testLike() {
        conditionElement.like("あ");
        List<BindValue> bindValues = conditionResult.getBindValues();
        BindValue bv = bindValues.get(0);
        assertEquals(COLUMN, bv.getColumn().getName());
        assertEquals(Operator.LIKE, bv.getOperator());
        assertEquals("あ", bv.getArgs()[0]);
    }

}
