/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.dialect;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.GenerationType;
import javax.persistence.TemporalType;
import org.seasar.extension.jdbc.DbmsDialect;
import org.seasar.extension.jdbc.FromClause;
import org.seasar.extension.jdbc.JoinColumnMeta;
import org.seasar.extension.jdbc.JoinType;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.SelectForUpdateType;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.WhereClause;
import org.seasar.extension.jdbc.exception.OrderByNotFoundRuntimeException;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.extension.jdbc.util.QueryTokenizer;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;
import org.seasar.framework.util.tiger.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardDialect
implements DbmsDialect {
    protected static final Set<String> entityExistsExceptionStateCode = CollectionsUtil.newHashSet(Arrays.asList("23", "27", "44"));

    @Override
    public String getName() {
        return null;
    }

    @Override
    public boolean supportsLimit() {
        return false;
    }

    @Override
    public boolean supportsOffset() {
        return this.supportsLimit();
    }

    @Override
    public boolean supportsOffsetWithoutLimit() {
        return this.supportsOffset();
    }

    @Override
    public boolean supportsCursor() {
        return true;
    }

    @Override
    public boolean needsParameterForResultSet() {
        return false;
    }

    @Override
    public String convertLimitSql(String sql, int offset, int limit) {
        return sql;
    }

    @Override
    public String convertGetCountSql(String sql) {
        return "select count(*) from ( " + sql + " ) COUNT_";
    }

    @Override
    public ValueType getValueType(PropertyMeta propertyMeta) {
        return propertyMeta.getValueType();
    }

    @Override
    public ValueType getValueType(Class<?> clazz, boolean lob, TemporalType temporalType) {
        ValueType valueType;
        if (lob) {
            if (clazz == String.class) {
                return ValueTypes.CLOB;
            }
            if (clazz == byte[].class) {
                return ValueTypes.BLOB;
            }
            if (Serializable.class.isAssignableFrom(clazz)) {
                return ValueTypes.SERIALIZABLE_BLOB;
            }
        } else if (clazz == byte[].class) {
            return ValueTypes.BYTE_ARRAY;
        }
        if (temporalType != null) {
            if (Date.class == clazz) {
                switch (temporalType) {
                    case DATE: {
                        return ValueTypes.DATE_SQLDATE;
                    }
                    case TIME: {
                        return ValueTypes.DATE_TIME;
                    }
                    case TIMESTAMP: {
                        return ValueTypes.DATE_TIMESTAMP;
                    }
                }
            }
            if (Calendar.class == clazz) {
                switch (temporalType) {
                    case DATE: {
                        return ValueTypes.CALENDAR_SQLDATE;
                    }
                    case TIME: {
                        return ValueTypes.CALENDAR_TIME;
                    }
                    case TIMESTAMP: {
                        return ValueTypes.CALENDAR_TIMESTAMP;
                    }
                }
            }
        }
        if ((valueType = this.getValueTypeInternal(clazz)) == null) {
            valueType = ValueTypes.getValueType(clazz);
        }
        if (valueType == ValueTypes.OBJECT && Serializable.class.isAssignableFrom(clazz)) {
            return ValueTypes.SERIALIZABLE_BYTE_ARRAY;
        }
        return valueType;
    }

    protected ValueType getValueTypeInternal(Class<?> clazz) {
        return null;
    }

    @Override
    public void setupJoin(FromClause fromClause, WhereClause whereClause, JoinType joinType, String tableName, String tableAlias, String fkTableAlias, String pkTableAlias, List<JoinColumnMeta> joinColumnMetaList, String lockHint, String condition) {
        fromClause.addSql(joinType, tableName, tableAlias, fkTableAlias, pkTableAlias, joinColumnMetaList, lockHint, condition);
    }

    @Override
    public GenerationType getDefaultGenerationType() {
        return GenerationType.TABLE;
    }

    @Override
    public boolean supportsIdentity() {
        return false;
    }

    @Override
    public boolean isInsertIdentityColumn() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    public String getIdentitySelectString(String tableName, String columnName) {
        return null;
    }

    @Override
    public boolean supportsSequence() {
        return false;
    }

    @Override
    public String getSequenceNextValString(String sequenceName, int allocationSize) {
        return null;
    }

    @Override
    public int getDefaultBatchSize() {
        return 0;
    }

    @Override
    public boolean supportsBatchUpdateResults() {
        return true;
    }

    protected String getRowNumberFunctionName() {
        return "row_number()";
    }

    protected String convertLimitSqlByRowNumber(String sql, int offset, int limit) throws OrderByNotFoundRuntimeException {
        StringBuilder buf = new StringBuilder(sql.length() + 150);
        String lowerSql = sql.toLowerCase();
        int startOfSelect = lowerSql.indexOf("select");
        buf.append(sql.substring(0, startOfSelect));
        buf.append("select * from ( select temp_.*, ");
        buf.append(this.getRowNumberFunctionName()).append(" over(");
        int orderByIndex = lowerSql.lastIndexOf("order by");
        if (orderByIndex <= 0) {
            throw new OrderByNotFoundRuntimeException(sql);
        }
        String orderBy = sql.substring(orderByIndex);
        buf.append(this.convertOrderBy(orderBy));
        sql = StringUtil.rtrim((String)sql.substring(0, orderByIndex));
        buf.append(") as rownumber_ from ( ");
        buf.append(sql.substring(startOfSelect));
        buf.append(" ) as temp_");
        buf.append(" ) as temp2_ where rownumber_ >= ");
        buf.append(offset + 1);
        if (limit > 0) {
            buf.append(" and rownumber_ <= ");
            buf.append(offset + limit);
        }
        return buf.toString();
    }

    protected String convertOrderBy(String orderBy) {
        StringBuilder sb = new StringBuilder(10 + orderBy.length());
        QueryTokenizer tokenizer = new QueryTokenizer(orderBy);
        int type = tokenizer.nextToken();
        while (type != -1) {
            String token = tokenizer.getToken();
            if (type == -2) {
                String[] names = StringUtil.split((String)token, (String)".");
                if (names.length == 2) {
                    sb.append("temp_.").append(names[1]);
                } else {
                    sb.append(token);
                }
            } else {
                sb.append(token);
            }
            type = tokenizer.nextToken();
        }
        return sb.toString();
    }

    @Override
    public boolean isUniqueConstraintViolation(Throwable t) {
        String state = this.getSQLState(t);
        if (state != null && state.length() >= 2) {
            return entityExistsExceptionStateCode.contains(state.substring(0, 2));
        }
        return false;
    }

    protected String getSQLState(Throwable t) {
        SQLException cause = this.getCauseSQLException(t);
        if (cause != null && !StringUtil.isEmpty((String)cause.getSQLState())) {
            return cause.getSQLState();
        }
        return null;
    }

    protected Integer getErrorCode(Throwable t) {
        SQLException cause = this.getCauseSQLException(t);
        if (cause != null) {
            return cause.getErrorCode();
        }
        return null;
    }

    protected SQLException getCauseSQLException(Throwable t) {
        SQLException cause = null;
        while (t != null) {
            if (t instanceof SQLException && (cause = (SQLException)SQLException.class.cast(t)).getNextException() != null) {
                cause = cause.getNextException();
                t = cause;
                continue;
            }
            t = t.getCause();
        }
        return cause;
    }

    @Override
    public boolean supportsForUpdate(SelectForUpdateType type, boolean withTarget) {
        return type == SelectForUpdateType.NORMAL && !withTarget;
    }

    @Override
    public String getForUpdateString(SelectForUpdateType type, int waitSeconds, Pair<String, String> ... aliases) {
        return " for update";
    }

    @Override
    public boolean supportsLockHint() {
        return false;
    }

    @Override
    public String getLockHintString(SelectForUpdateType type, int waitSeconds) {
        return "";
    }

    @Override
    public boolean supportsInnerJoinForUpdate() {
        return true;
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return true;
    }

    @Override
    public String getHintComment(String hint) {
        return "";
    }
}

