/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.lib;

import java.util.List;

/**
 * Daoの引数に取る検索条件の組み立て結果のインターフェースです。
 * 
 * @author azusa
 */
public interface ConditionResult {

    /**
     * バインド変数のリストを返します。
     * 
     * @return バインド変数のリスト
     */
    List<BindValue> getBindValues();

    /**
     * バインド変数を追加します。
     * 
     * @param bindValue
     *            バインド変数
     */
    void addBindValue(BindValue bindValue);

    /**
     * 並び替え順のリストを返します。
     * 
     * @return 並び替え順のリスト
     */
    List<Order> getOrderList();

    /**
     * SQLのクエリーを追加します。
     * 
     * 
     * @param query
     *            SQLのクエリー文
     * @param args
     *            SQLの引数
     */
    void addQuery(String query, Object... args);

    /**
     * SQLのクエリーを返します。
     * 
     * @return SQLのクエリー
     */
    Query getQuery();

    /**
     * 並び替え順を追加します。
     * 
     * @param column
     *            並び替えるカラム
     * @param asc
     *            昇順の場合<code>true</code>、降順の場合<code>false</code>
     */
    void addOrder(Column column, boolean asc);

}
