/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.lib.impl;

import org.seasar.codegen.lib.Column;
import org.seasar.codegen.lib.Order;

/**
 * @author azusa
 * 
 */
public class OrderImpl implements Order {

    /**
     * コンストラクタです。
     * 
     * @param column
     *            カラム
     * @param asc
     *            昇順の場合<code>true</code>、降順の場合<code>false</code>
     */
    public OrderImpl(Column column, boolean asc) {
        super();
        this.column = column;
        this.asc = asc;
    }

    private Column column;

    private boolean asc;

    /*
     * (非 Javadoc)
     * 
     * @see org.seasar.codegen.lib.Order#getColumn()
     */
    public Column getColumn() {
        return column;
    }

    /*
     * (非 Javadoc)
     * 
     * @see org.seasar.codegen.lib.Order#isAsc()
     */
    public boolean isAsc() {
        return asc;
    }

    @Override
    public String toString() {
        return column.toString() + " " + (asc ? "" : "DESC");
    }

}
