/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.lib.internal.impl;

import org.seasar.codegen.lib.Column;
import org.seasar.codegen.lib.exception.NullConditionValueException;

/**
 * @author azusa
 * 
 */
public class ValueValidator {

    /**
     * 
     * @param value
     *            検証対象の値
     * @param column
     *            検索条件のカラム
     * @throws NullConditionValueException
     *             引数valueが<code>null</code>の場合
     */
    public static void validate(Object value, Column column) {
        if (value == null) {
            throw new NullConditionValueException(column.getCodnitionClass().getName(), column.getName());
        }
    }
}
