/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.lib;

/**
 * SQLの演算子を指定する列挙型です。
 * 
 * @author azusa
 * 
 */
public enum Operator {

    /**
     * 値が等しい条件を示します。
     */
    EQUAL("=", "?"),
    /**
     * SQLのIN句の条件を示します。
     **/
    IN("IN", "?"),
    /**
     * SQLのNOT NULLの条件を示します。
     */
    NOT_NULL("IS NOT NULL", ""),

    /**
     * SQLのNULLの条件を示します。
     */
    NULL("IS NULL", ""),
    /**
     * 未満の条件を示します。
     */
    LESS("<", "?"),

    /**
     * 以下の条件を示します。
     */
    LESSTHAN("<=", "?"),

    /**
     * SQLのLIKE句の条件を示します。
     */
    LIKE("LIKE", "?"),

    /**
     * 「より大きい」条件を示します。
     */
    MORE(">", "?"),
    /**
     * 以上の条件を示します。
     */
    MORETHAN(">=", "?"),
    /**
     * SQLのNOT IN句の条件を示します。
     */
    NOTIN("not in", "?"),
    /**
     * 等しくない値の条件を示します。
     */
    NOT("<>", "?");

    /**
     * SQLの演算子を返します。
     * 
     * @return SQLの演算子
     */
    public String getOperator() {
        return operator;
    }

    /**
     * SQLのバインド変数の記述を返します。
     * 
     * @return SQLのバインド変数の記述
     */
    public String getBind() {
        return bind;
    }

    private String operator;

    private String bind;

    private Operator(String operator, String bind) {
        this.operator = operator;
        this.bind = bind;
    }
}
