/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.lib.impl;

import java.util.Date;

import org.seasar.codegen.lib.Column;
import org.seasar.codegen.lib.ConditionResult;
import org.seasar.codegen.lib.Operator;
import org.seasar.codegen.lib.internal.impl.FromToOption;
import org.seasar.codegen.lib.internal.impl.ValueValidator;

/**
 * @author azusa
 * 
 */
public class DateConditionElementImpl<T> extends ConditionElementImpl<T> implements
        org.seasar.codegen.lib.DateConditionElement<T> {

    /**
     * コンストラクタです。
     * 
     * @param conditionResult
     *            検索条件の組み立て結果となるオブジェクト
     * @param column
     *            カラム
     */
    public DateConditionElementImpl(ConditionResult conditionResult, Column column) {
        super(conditionResult, column);
    }

    /*
     * (非 Javadoc)
     * 
     * @see org.seasar.codegen.lib.DateConditionElement#dateFrom(java.util.Date)
     */
    public void dateFrom(Date from) {
        ValueValidator.validate(from, column);
        Date date = FromToOption.filterFromDate(from);
        conditionResult.addBindValue(new BindValueImpl(column, Operator.MORETHAN, new Object[] { date }));

    }

    /*
     * (非 Javadoc)
     * 
     * @see
     * org.seasar.codegen.lib.DateConditionElement#dateFromTo(java.util.Date,
     * java.util.Date)
     */
    public void dateFromTo(Date from, Date to) {
        dateFrom(from);
        dateTo(to);
    }

    /*
     * (非 Javadoc)
     * 
     * @see org.seasar.codegen.lib.DateConditionElement#dateTo(java.util.Date)
     */
    public void dateTo(Date to) {
        ValueValidator.validate(to, column);
        Date date = FromToOption.filterToDate(to);
        conditionResult.addBindValue(new BindValueImpl(column, Operator.LESS, new Object[] { date }));

    }

}
