/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import junit.framework.TestCase;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;

public class DisposableUtilTest
extends TestCase {
    private int count;

    protected void setUp() throws Exception {
        DisposableUtil.dispose();
    }

    public void test1() throws Exception {
        DisposableUtil.add((Disposable)new TestDisposable());
        DisposableUtilTest.assertEquals((int)1, (int)DisposableUtil.disposables.size());
        DisposableUtil.dispose();
        DisposableUtilTest.assertEquals((int)1, (int)this.count);
        DisposableUtilTest.assertEquals((int)0, (int)DisposableUtil.disposables.size());
    }

    public void test2() throws Exception {
        DisposableUtil.add((Disposable)new TestDisposable());
        DisposableUtil.add((Disposable)new TestDisposable());
        DisposableUtilTest.assertEquals((int)2, (int)DisposableUtil.disposables.size());
        DisposableUtil.dispose();
        DisposableUtilTest.assertEquals((int)2, (int)this.count);
        DisposableUtilTest.assertEquals((int)0, (int)DisposableUtil.disposables.size());
    }

    public void test3() throws Exception {
        DisposableUtil.add((Disposable)new TestDisposable());
        DisposableUtil.add((Disposable)new TestDisposable2());
        DisposableUtil.add((Disposable)new TestDisposable());
        DisposableUtilTest.assertEquals((int)3, (int)DisposableUtil.disposables.size());
        DisposableUtil.dispose();
        DisposableUtilTest.assertEquals((int)3, (int)this.count);
        DisposableUtilTest.assertEquals((int)0, (int)DisposableUtil.disposables.size());
    }

    public void deregisterAllDriversTest() throws Exception {
        Class<?> clazz = Class.forName("org.hsqldb.jdbcDriver");
        Driver d = (Driver)clazz.newInstance();
        DriverManager.registerDriver(d);
        int i = 0;
        Enumeration<Driver> e = DriverManager.getDrivers();
        while (e.hasMoreElements()) {
            e.nextElement();
            ++i;
        }
        DisposableUtilTest.assertEquals((int)2, (int)i);
        DisposableUtil.deregisterAllDrivers();
        int j = 0;
        Enumeration<Driver> e2 = DriverManager.getDrivers();
        while (e2.hasMoreElements()) {
            e2.nextElement();
            ++j;
        }
        DisposableUtilTest.assertEquals((int)0, (int)j);
    }

    public class TestDisposable2
    implements Disposable {
        public void dispose() {
            ++DisposableUtilTest.this.count;
            throw new RuntimeException();
        }
    }

    public class TestDisposable
    implements Disposable {
        public void dispose() {
            ++DisposableUtilTest.this.count;
        }
    }
}

