/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.impl;

import junit.framework.TestCase;
import org.seasar.framework.beans.PropertyNotFoundRuntimeException;
import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.DestroyMethodDef;
import org.seasar.framework.container.Expression;
import org.seasar.framework.container.InitMethodDef;
import org.seasar.framework.container.InterTypeDef;
import org.seasar.framework.container.MetaDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.assembler.AutoBindingDefFactory;
import org.seasar.framework.container.deployer.InstanceDefFactory;
import org.seasar.framework.container.impl.ArgDefImpl;
import org.seasar.framework.container.impl.AspectDefImpl;
import org.seasar.framework.container.impl.DestroyMethodDefImpl;
import org.seasar.framework.container.impl.InitMethodDefImpl;
import org.seasar.framework.container.impl.InterTypeDefImpl;
import org.seasar.framework.container.impl.MetaDefImpl;
import org.seasar.framework.container.impl.PropertyDefImpl;
import org.seasar.framework.container.impl.SimpleComponentDef;
import org.seasar.framework.container.ognl.OgnlExpression;

public class SimpleComponentDefTest
extends TestCase {
    public void testBasics() {
        SimpleComponentDef cd = new SimpleComponentDef((Object)"Hoge", "hoge");
        SimpleComponentDefTest.assertEquals((Object)"Hoge", (Object)cd.getComponent());
        SimpleComponentDefTest.assertEquals((String)"hoge", (String)cd.getComponentName());
        SimpleComponentDefTest.assertEquals((Object)String.class, (Object)cd.getComponentClass());
        SimpleComponentDefTest.assertEquals((Object)String.class, (Object)cd.getConcreteClass());
        SimpleComponentDefTest.assertEquals((Object)InstanceDefFactory.SINGLETON, (Object)cd.getInstanceDef());
        try {
            cd.setInstanceDef(InstanceDefFactory.OUTER);
            SimpleComponentDefTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        SimpleComponentDefTest.assertEquals((Object)AutoBindingDefFactory.NONE, (Object)cd.getAutoBindingDef());
        try {
            cd.setAutoBindingDef(AutoBindingDefFactory.AUTO);
            SimpleComponentDefTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        SimpleComponentDefTest.assertFalse((boolean)cd.isExternalBinding());
        try {
            cd.setExternalBinding(true);
            SimpleComponentDefTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        SimpleComponentDefTest.assertNull((Object)cd.getExpression());
        try {
            cd.setExpression((Expression)new OgnlExpression("true"));
            SimpleComponentDefTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        cd.init();
        cd.destroy();
    }

    public void testArgDef() {
        SimpleComponentDef cd = new SimpleComponentDef((Object)"Hoge", "hoge");
        SimpleComponentDefTest.assertEquals((int)0, (int)cd.getArgDefSize());
        try {
            cd.addArgDef((ArgDef)new ArgDefImpl());
            SimpleComponentDefTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            cd.getArgDef(0);
            SimpleComponentDefTest.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testPropertyDef() {
        SimpleComponentDef cd = new SimpleComponentDef((Object)"Hoge", "hoge");
        SimpleComponentDefTest.assertEquals((int)0, (int)cd.getPropertyDefSize());
        try {
            cd.addPropertyDef((PropertyDef)new PropertyDefImpl("hoge"));
            SimpleComponentDefTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            cd.getPropertyDef(0);
            SimpleComponentDefTest.fail();
        }
        catch (ArrayIndexOutOfBoundsException expected) {
            // empty catch block
        }
        SimpleComponentDefTest.assertFalse((boolean)cd.hasPropertyDef("hoge"));
        try {
            cd.getPropertyDef("hoge");
            SimpleComponentDefTest.fail();
        }
        catch (PropertyNotFoundRuntimeException propertyNotFoundRuntimeException) {
            // empty catch block
        }
    }

    public void testInitMethodDef() {
        SimpleComponentDef cd = new SimpleComponentDef((Object)"Hoge", "hoge");
        SimpleComponentDefTest.assertEquals((int)0, (int)cd.getInitMethodDefSize());
        try {
            cd.addInitMethodDef((InitMethodDef)new InitMethodDefImpl());
            SimpleComponentDefTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            cd.getInitMethodDef(0);
            SimpleComponentDefTest.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testDestroyMethodDef() {
        SimpleComponentDef cd = new SimpleComponentDef((Object)"Hoge", "hoge");
        SimpleComponentDefTest.assertEquals((int)0, (int)cd.getDestroyMethodDefSize());
        try {
            cd.addDestroyMethodDef((DestroyMethodDef)new DestroyMethodDefImpl());
            SimpleComponentDefTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            cd.getDestroyMethodDef(0);
            SimpleComponentDefTest.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testAspectDef() {
        SimpleComponentDef cd = new SimpleComponentDef((Object)"Hoge", "hoge");
        SimpleComponentDefTest.assertEquals((int)0, (int)cd.getAspectDefSize());
        try {
            cd.addAspectDef((AspectDef)new AspectDefImpl());
            SimpleComponentDefTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            cd.getAspectDef(0);
            SimpleComponentDefTest.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testInterTypeDef() {
        SimpleComponentDef cd = new SimpleComponentDef((Object)"Hoge", "hoge");
        SimpleComponentDefTest.assertEquals((int)0, (int)cd.getInterTypeDefSize());
        try {
            cd.addInterTypeDef((InterTypeDef)new InterTypeDefImpl());
            SimpleComponentDefTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            cd.getInterTypeDef(0);
            SimpleComponentDefTest.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testMetaDef() {
        SimpleComponentDef cd = new SimpleComponentDef((Object)"Hoge", "hoge");
        SimpleComponentDefTest.assertEquals((int)0, (int)cd.getMetaDefSize());
        try {
            cd.addMetaDef((MetaDef)new MetaDefImpl());
            SimpleComponentDefTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            cd.getMetaDef(0);
            SimpleComponentDefTest.fail();
        }
        catch (ArrayIndexOutOfBoundsException expected) {
            // empty catch block
        }
        SimpleComponentDefTest.assertNull((Object)cd.getMetaDef("hoge"));
        MetaDef[] metaDefs = cd.getMetaDefs("hoge");
        SimpleComponentDefTest.assertNotNull((Object)metaDefs);
        SimpleComponentDefTest.assertEquals((int)0, (int)metaDefs.length);
    }
}

