/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.hotdeploy.creator;

import org.seasar.framework.container.ComponentCreator;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.creator.DaoCreator;
import org.seasar.framework.container.hotdeploy.creator.HotdeployCreatorTestCase;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ClassUtil;

public class DaoHotdeployCreatorTest
extends HotdeployCreatorTestCase {
    protected ComponentCreator newOndemandCreator(NamingConvention convention) {
        return new DaoCreator(convention);
    }

    public void testIsTargetByComponentName() throws Exception {
        String name = "fooDao";
        ComponentDef cd = this.getComponentDef(name);
        DaoHotdeployCreatorTest.assertNotNull((Object)cd);
        DaoHotdeployCreatorTest.assertEquals((String)name, (String)cd.getComponentName());
        DaoHotdeployCreatorTest.assertTrue((boolean)this.getContainer().hasComponentDef((Object)"barDao"));
        DaoHotdeployCreatorTest.assertFalse((boolean)this.getContainer().hasComponentDef((Object)"hogeDao"));
        DaoHotdeployCreatorTest.assertFalse((boolean)this.getContainer().hasComponentDef((Object)"hogeHogeDao"));
    }

    public void testIsTargetByClass() throws Exception {
        String pkgName = ClassUtil.getPackageName(((Object)((Object)this)).getClass());
        Class clazz = ClassUtil.forName((String)(pkgName + ".dao.FooDao"));
        DaoHotdeployCreatorTest.assertTrue((boolean)this.getContainer().hasComponentDef((Object)clazz));
        clazz = ClassUtil.forName((String)(pkgName + ".hoge.HogeDao"));
        DaoHotdeployCreatorTest.assertFalse((boolean)this.getContainer().hasComponentDef((Object)clazz));
        clazz = ClassUtil.forName((String)(pkgName + "hoge.HogeHogeDao"));
        DaoHotdeployCreatorTest.assertFalse((boolean)this.getContainer().hasComponentDef((Object)clazz));
    }
}

