/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.external;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;
import org.seasar.framework.container.external.RebuildableExternalContextMap;
import org.seasar.framework.container.hotdeploy.HotdeployClassLoader;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.convention.impl.NamingConventionImpl;

public class RebuildableExternalContextMapTest
extends TestCase {
    ClassLoader originalLoader;

    protected void setUp() throws Exception {
        super.setUp();
        this.originalLoader = Thread.currentThread().getContextClassLoader();
    }

    protected void tearDown() throws Exception {
        Thread.currentThread().setContextClassLoader(this.originalLoader);
        HotdeployUtil.clearHotdeploy();
        super.tearDown();
    }

    public void test() throws Exception {
        NamingConventionImpl convention = new NamingConventionImpl();
        convention.addRootPackageName("org.seasar.framework.external");
        HotdeployUtil.setHotdeploy((boolean)true);
        HotdeployClassLoader hotLoader = new HotdeployClassLoader(this.originalLoader, (NamingConvention)convention);
        Thread.currentThread().setContextClassLoader((ClassLoader)hotLoader);
        Foo foo = new Foo("hoge");
        new TestMap().put("foo", foo);
        Foo foo2 = (Foo)new TestMap().get("foo");
        RebuildableExternalContextMapTest.assertSame((Object)foo, (Object)foo2);
        RebuildableExternalContextMapTest.assertSame((Object)foo2, (Object)new TestMap().get("foo"));
        RebuildableExternalContextMapTest.assertEquals((String)"hoge", (String)foo2.name);
        HotdeployClassLoader hotLoader2 = new HotdeployClassLoader(this.originalLoader, (NamingConvention)convention);
        Thread.currentThread().setContextClassLoader((ClassLoader)hotLoader2);
        Foo foo3 = (Foo)new TestMap().get("foo");
        RebuildableExternalContextMapTest.assertNotSame((Object)foo, (Object)foo3);
        RebuildableExternalContextMapTest.assertNotSame((Object)foo2, (Object)foo3);
        RebuildableExternalContextMapTest.assertSame((Object)foo3, (Object)new TestMap().get("foo"));
        RebuildableExternalContextMapTest.assertEquals((String)"hoge", (String)foo2.name);
    }

    public static class Foo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String name;

        public Foo(String name) {
            this.name = name;
        }
    }

    public static class TestMap
    extends RebuildableExternalContextMap {
        static Map map = new HashMap();

        protected Object getAttribute(String key) {
            return map.get(key);
        }

        protected Iterator getAttributeNames() {
            return map.keySet().iterator();
        }

        protected void removeAttribute(String key) {
            map.remove(key);
        }

        protected void setAttribute(String key, Object value) {
            map.put(key, value);
        }
    }
}

