/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.deployer;

import junit.framework.TestCase;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.deployer.RequestComponentDeployer;
import org.seasar.framework.container.external.servlet.HttpServletExternalContext;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockServletContextImpl;

public class RequestComponentDeployerTest
extends TestCase {
    public void testDeployAutoAutoConstructor() throws Exception {
        MockServletContextImpl ctx = new MockServletContextImpl("s2jsf-example");
        MockHttpServletRequest request = ctx.createRequest("/hello.html");
        S2ContainerImpl container = new S2ContainerImpl();
        HttpServletExternalContext extCtx = new HttpServletExternalContext();
        extCtx.setRequest((Object)request);
        container.setExternalContext((ExternalContext)extCtx);
        ComponentDefImpl cd = new ComponentDefImpl(Foo.class, "foo");
        container.register((ComponentDef)cd);
        RequestComponentDeployer deployer = new RequestComponentDeployer((ComponentDef)cd);
        Foo foo = (Foo)deployer.deploy();
        RequestComponentDeployerTest.assertSame((String)"1", (Object)foo, (Object)request.getAttribute("foo"));
        RequestComponentDeployerTest.assertSame((String)"2", (Object)foo, (Object)deployer.deploy());
    }

    public static class Foo {
        private String message_;

        public void setMessage(String message) {
            this.message_ = message;
        }

        public String getMessage() {
            return this.message_;
        }
    }
}

