/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.message;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import junit.framework.TestCase;
import org.seasar.framework.message.MessageResourceBundle;
import org.seasar.framework.message.MessageResourceBundleFacade;
import org.seasar.framework.message.MessageResourceBundleFactory;

public class MessageResourceBundleFactoryTest
extends TestCase {
    private static final String BASE_NAME = "SSRMessages";
    private static final String PATH = "SSRMessages.properties";

    public void tearDown() {
        MessageResourceBundleFactory.clear();
    }

    public void testLoadFacade() throws Exception {
        MessageResourceBundleFacade facade = MessageResourceBundleFactory.loadFacade((String)PATH);
        MessageResourceBundleFactoryTest.assertNotNull((Object)facade);
        MessageResourceBundleFactoryTest.assertEquals((String)"{0} not found", (String)facade.getBundle().get("ESSR0001"));
    }

    public void testGetNullableBundle() throws Exception {
        MessageResourceBundle bundle = MessageResourceBundleFactory.getNullableBundle((String)BASE_NAME, (Locale)Locale.JAPANESE);
        MessageResourceBundleFactoryTest.assertNotNull((Object)bundle);
        MessageResourceBundleFactoryTest.assertNotNull((Object)bundle.getParent());
        MessageResourceBundleFactoryTest.assertEquals((String)"{0}\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", (String)bundle.get("ESSR0001"));
        bundle = MessageResourceBundleFactory.getNullableBundle((String)BASE_NAME, (Locale)Locale.ITALIAN);
        MessageResourceBundleFactoryTest.assertNotNull((Object)bundle);
        MessageResourceBundleFactoryTest.assertNull((Object)bundle.getParent());
        MessageResourceBundleFactoryTest.assertEquals((String)"{0} not found", (String)bundle.get("ESSR0001"));
    }

    public void testGetNullabelBundle2() throws Exception {
        String baseName = "org.seasar.framework.message.strings";
        MessageResourceBundle bundle = MessageResourceBundleFactory.getNullableBundle((String)baseName, (Locale)Locale.JAPANESE);
        MessageResourceBundleFactoryTest.assertNotNull((Object)bundle);
        MessageResourceBundleFactoryTest.assertNotNull((Object)bundle.getParent());
        MessageResourceBundleFactoryTest.assertNull((Object)bundle.getParent().getParent());
        MessageResourceBundleFactoryTest.assertEquals((String)"hogehoge", (String)bundle.get("text"));
        bundle = MessageResourceBundleFactory.getNullableBundle((String)baseName, (Locale)new Locale("ja", "JP"));
        MessageResourceBundleFactoryTest.assertNotNull((Object)bundle);
        MessageResourceBundleFactoryTest.assertNotNull((Object)bundle.getParent());
        MessageResourceBundleFactoryTest.assertNotNull((Object)bundle.getParent().getParent());
        MessageResourceBundleFactoryTest.assertNull((Object)bundle.getParent().getParent().getParent());
        MessageResourceBundleFactoryTest.assertEquals((String)"hogehogehoge", (String)bundle.get("text"));
        bundle = MessageResourceBundleFactory.getNullableBundle((String)baseName, (Locale)new Locale("ja", "JP", "WIN"));
        MessageResourceBundleFactoryTest.assertNotNull((Object)bundle);
        MessageResourceBundleFactoryTest.assertNotNull((Object)bundle.getParent());
        MessageResourceBundleFactoryTest.assertNotNull((Object)bundle.getParent().getParent());
        MessageResourceBundleFactoryTest.assertNotNull((Object)bundle.getParent().getParent().getParent());
        MessageResourceBundleFactoryTest.assertNull((Object)bundle.getParent().getParent().getParent().getParent());
        MessageResourceBundleFactoryTest.assertEquals((String)"hogehogehogehoge", (String)bundle.get("text"));
        bundle = MessageResourceBundleFactory.getNullableBundle((String)baseName, (Locale)new Locale("en", "US"));
        MessageResourceBundleFactoryTest.assertNotNull((Object)bundle);
        MessageResourceBundleFactoryTest.assertNotNull((Object)bundle.getParent());
        MessageResourceBundleFactoryTest.assertNotNull((Object)bundle.getParent().getParent());
        MessageResourceBundleFactoryTest.assertNull((Object)bundle.getParent().getParent().getParent());
        MessageResourceBundleFactoryTest.assertEquals((String)"foobar", (String)bundle.get("text"));
        bundle = MessageResourceBundleFactory.getNullableBundle((String)baseName, (Locale)new Locale("en", "UK"));
        MessageResourceBundleFactoryTest.assertNotNull((Object)bundle);
        MessageResourceBundleFactoryTest.assertNotNull((Object)bundle.getParent());
        MessageResourceBundleFactoryTest.assertNull((Object)bundle.getParent().getParent());
        MessageResourceBundleFactoryTest.assertEquals((String)"foo", (String)bundle.get("text"));
    }

    public void testCalcurateBundleNames() throws Exception {
        String[] bundleNames = MessageResourceBundleFactory.calcurateBundleNames((String)BASE_NAME, (Locale)Locale.JAPANESE);
        List<String> expected = Arrays.asList(BASE_NAME, "SSRMessages_ja");
        MessageResourceBundleFactoryTest.assertEquals(expected, Arrays.asList(bundleNames));
        bundleNames = MessageResourceBundleFactory.calcurateBundleNames((String)BASE_NAME, (Locale)new Locale("ja", "JP"));
        expected = Arrays.asList(BASE_NAME, "SSRMessages_ja", "SSRMessages_ja_JP");
        MessageResourceBundleFactoryTest.assertEquals(expected, Arrays.asList(bundleNames));
        bundleNames = MessageResourceBundleFactory.calcurateBundleNames((String)BASE_NAME, (Locale)new Locale("ja", "JP", "WIN"));
        expected = Arrays.asList(BASE_NAME, "SSRMessages_ja", "SSRMessages_ja_JP", "SSRMessages_ja_JP_WIN");
        MessageResourceBundleFactoryTest.assertEquals(expected, Arrays.asList(bundleNames));
        bundleNames = MessageResourceBundleFactory.calcurateBundleNames((String)BASE_NAME, (Locale)new Locale("ja", "", "WIN"));
        expected = Arrays.asList(BASE_NAME, "SSRMessages_ja", "SSRMessages_ja__WIN");
        MessageResourceBundleFactoryTest.assertEquals(expected, Arrays.asList(bundleNames));
        bundleNames = MessageResourceBundleFactory.calcurateBundleNames((String)BASE_NAME, (Locale)new Locale("", "JP", "WIN"));
        expected = Arrays.asList(BASE_NAME, "SSRMessages__JP", "SSRMessages__JP_WIN");
        MessageResourceBundleFactoryTest.assertEquals(expected, Arrays.asList(bundleNames));
        bundleNames = MessageResourceBundleFactory.calcurateBundleNames((String)BASE_NAME, (Locale)new Locale("", "JP"));
        expected = Arrays.asList(BASE_NAME, "SSRMessages__JP");
        MessageResourceBundleFactoryTest.assertEquals(expected, Arrays.asList(bundleNames));
        bundleNames = MessageResourceBundleFactory.calcurateBundleNames((String)BASE_NAME, (Locale)new Locale("", "", "WIN"));
        expected = Arrays.asList(BASE_NAME, "SSRMessages___WIN");
        MessageResourceBundleFactoryTest.assertEquals(expected, Arrays.asList(bundleNames));
    }
}

