/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.customizer;

import java.lang.reflect.Field;
import java.util.List;
import org.seasar.framework.container.ComponentCustomizer;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.MetaDef;
import org.seasar.framework.container.customizer.AspectCustomizer;
import org.seasar.framework.container.customizer.CustomizerChain;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.MetaDefImpl;
import org.seasar.framework.unit.S2FrameworkTestCase;

public class CustomizerChainTest
extends S2FrameworkTestCase {
    public void testCustomize() throws Exception {
        ComponentDefImpl cd = new ComponentDefImpl();
        CustomizerChain chain = new CustomizerChain();
        HogeCustomizer customizer = new HogeCustomizer();
        chain.addCustomizer((ComponentCustomizer)customizer);
        chain.addCustomizer((ComponentCustomizer)customizer);
        chain.customize((ComponentDef)cd);
        MetaDef[] mdefs = cd.getMetaDefs("hoge");
        CustomizerChainTest.assertEquals((int)2, (int)mdefs.length);
    }

    public void testAddAspect() throws Exception {
        Field interceptorName = AspectCustomizer.class.getDeclaredField("interceptorNames");
        interceptorName.setAccessible(true);
        Field pointcut = AspectCustomizer.class.getDeclaredField("pointcut");
        pointcut.setAccessible(true);
        Field useLookupAdapter = AspectCustomizer.class.getDeclaredField("useLookupAdapter");
        useLookupAdapter.setAccessible(true);
        CustomizerChain chain = new CustomizerChain();
        chain.addAspectCustomizer("fooInterceptor");
        CustomizerChainTest.assertEquals((int)1, (int)chain.getCustomizerSize());
        AspectCustomizer customizer = (AspectCustomizer)chain.getCustomizer(0);
        List interceptorNames = (List)interceptorName.get(customizer);
        CustomizerChainTest.assertEquals((int)1, (int)interceptorNames.size());
        CustomizerChainTest.assertEquals((Object)"fooInterceptor", interceptorNames.get(0));
        CustomizerChainTest.assertNull((Object)pointcut.get(customizer));
        CustomizerChainTest.assertNull((Object)pointcut.get(customizer));
        CustomizerChainTest.assertFalse((boolean)((Boolean)useLookupAdapter.get(customizer)));
        chain.addAspectCustomizer("barInterceptor", "do.*");
        CustomizerChainTest.assertEquals((int)2, (int)chain.getCustomizerSize());
        customizer = (AspectCustomizer)chain.getCustomizer(1);
        interceptorNames = (List)interceptorName.get(customizer);
        CustomizerChainTest.assertEquals((int)1, (int)interceptorNames.size());
        CustomizerChainTest.assertEquals((Object)"barInterceptor", interceptorNames.get(0));
        CustomizerChainTest.assertEquals((Object)"do.*", (Object)pointcut.get(customizer));
        CustomizerChainTest.assertFalse((boolean)((Boolean)useLookupAdapter.get(customizer)));
        chain.addAspectCustomizer("bazInterceptor", true);
        CustomizerChainTest.assertEquals((int)3, (int)chain.getCustomizerSize());
        customizer = (AspectCustomizer)chain.getCustomizer(2);
        interceptorNames = (List)interceptorName.get(customizer);
        CustomizerChainTest.assertEquals((int)1, (int)interceptorNames.size());
        CustomizerChainTest.assertEquals((Object)"bazInterceptor", interceptorNames.get(0));
        CustomizerChainTest.assertNull((Object)pointcut.get(customizer));
        CustomizerChainTest.assertTrue((boolean)((Boolean)useLookupAdapter.get(customizer)));
        chain.addAspectCustomizer("hogeInterceptor", ".*", true);
        CustomizerChainTest.assertEquals((int)4, (int)chain.getCustomizerSize());
        customizer = (AspectCustomizer)chain.getCustomizer(3);
        interceptorNames = (List)interceptorName.get(customizer);
        CustomizerChainTest.assertEquals((int)1, (int)interceptorNames.size());
        CustomizerChainTest.assertEquals((Object)"hogeInterceptor", interceptorNames.get(0));
        CustomizerChainTest.assertEquals((Object)".*", (Object)pointcut.get(customizer));
        CustomizerChainTest.assertTrue((boolean)((Boolean)useLookupAdapter.get(customizer)));
    }

    public static class HogeCustomizer
    implements ComponentCustomizer {
        public void customize(ComponentDef componentDef) {
            MetaDefImpl md = new MetaDefImpl("hoge");
            componentDef.addMetaDef((MetaDef)md);
        }
    }
}

