/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.proxy;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.Aspect;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.impl.AspectImpl;
import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.aop.interceptors.TraceInterceptor;
import org.seasar.framework.aop.proxy.AopProxy;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.SerializeUtil;

public class AopProxyTest
extends TestCase {
    public void testIntercept() throws Exception {
        TestInvocation invocation = new TestInvocation();
        PointcutImpl pointcut = new PointcutImpl(new String[]{"getTime"});
        AspectImpl aspect = new AspectImpl((MethodInterceptor)invocation, (Pointcut)pointcut);
        AopProxy aopProxy = new AopProxy(Date.class, new Aspect[]{aspect});
        Date proxy = (Date)aopProxy.create();
        System.out.println(proxy.getTime());
        AopProxyTest.assertEquals((String)"2", (boolean)true, (boolean)invocation.invoked_);
    }

    public void testInterface() throws Exception {
        PointcutImpl pointcut = new PointcutImpl(new String[]{"greeting"});
        AspectImpl aspect = new AspectImpl((MethodInterceptor)new HelloInterceptor(), (Pointcut)pointcut);
        AopProxy aopProxy = new AopProxy(Hello.class, new Aspect[]{aspect});
        Hello proxy = (Hello)aopProxy.create();
        AopProxyTest.assertEquals((String)"1", (String)"Hello", (String)proxy.greeting());
    }

    public void testCreateForArgs() throws Exception {
        AspectImpl aspect = new AspectImpl((MethodInterceptor)new TraceInterceptor());
        AopProxy aopProxy = new AopProxy(HelloImpl.class, new Aspect[]{aspect});
        Hello proxy = (Hello)aopProxy.create(new Class[]{String.class}, new Object[]{"Hello"});
        AopProxyTest.assertEquals((String)"1", (String)"Hello", (String)proxy.greeting());
        System.out.println(proxy.hashCode());
    }

    public void testEquals() throws Exception {
        PointcutImpl pointcut = new PointcutImpl(new String[]{"greeting"});
        AspectImpl aspect = new AspectImpl((MethodInterceptor)new HelloInterceptor(), (Pointcut)pointcut);
        AopProxy aopProxy = new AopProxy(Hello.class, new Aspect[]{aspect});
        Hello proxy = (Hello)aopProxy.create();
        AopProxyTest.assertEquals((String)"1", (boolean)true, (boolean)proxy.equals(proxy));
        AopProxyTest.assertEquals((String)"2", (boolean)false, (boolean)proxy.equals(null));
        AopProxyTest.assertEquals((String)"3", (boolean)false, (boolean)proxy.equals("hoge"));
    }

    public void testEqualsByValue() {
        PointcutImpl pointcut = new PointcutImpl(new String[]{"toString"});
        AspectImpl aspect = new AspectImpl((MethodInterceptor)new HelloInterceptor(), (Pointcut)pointcut);
        AopProxy aopProxy = new AopProxy(BigDecimal.class, new Aspect[]{aspect});
        BigDecimal proxy = (BigDecimal)aopProxy.create(new Class[]{String.class}, new Object[]{"10"});
        AopProxyTest.assertTrue((String)"1", (boolean)proxy.equals(proxy));
        AopProxyTest.assertTrue((String)"2", (boolean)proxy.equals(new BigDecimal("10")));
        AopProxyTest.assertFalse((String)"3", (boolean)proxy.equals(null));
        AopProxyTest.assertFalse((String)"3", (boolean)proxy.equals(new BigDecimal("100")));
        AopProxyTest.assertFalse((String)"3", (boolean)proxy.equals("Hoge"));
    }

    public void testFinalMethod() throws Exception {
        PointcutImpl pointcut = new PointcutImpl(new String[]{"greeting"});
        AspectImpl aspect = new AspectImpl((MethodInterceptor)new HelloInterceptor(), (Pointcut)pointcut);
        AopProxy aopProxy = new AopProxy(HelloImpl3.class, new Aspect[]{aspect});
        Hello proxy = (Hello)aopProxy.create();
        AopProxyTest.assertEquals((String)"1", (String)"hoge", (String)proxy.greeting());
    }

    public void testDefaultMethod() throws Exception {
        if (!MethodUtil.isDefaultMethod((Method)ClassUtil.getMethod((Class)Iterator.class, (String)"remove", null))) {
            return;
        }
        System.out.println("before default test");
        try {
            AspectImpl aspect = new AspectImpl((MethodInterceptor)new TraceInterceptor());
            AopProxy aopProxy = new AopProxy(Iterator.class, new Aspect[]{aspect});
            Iterator proxy = (Iterator)aopProxy.create();
            proxy.remove();
        }
        catch (UnsupportedOperationException expected) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void testSerialize() throws Exception {
        AspectImpl aspect = new AspectImpl((MethodInterceptor)new TraceInterceptor());
        AopProxy aopProxy = new AopProxy(HelloImpl.class, new Aspect[]{aspect});
        Hello proxy = (Hello)aopProxy.create(new Class[]{String.class}, new Object[]{"Hello"});
        Hello copy = (Hello)SerializeUtil.serialize((Object)proxy);
        AopProxyTest.assertEquals((String)"1", (String)"Hello", (String)copy.greeting());
    }

    public void testPerformance() throws Exception {
        int i;
        Date target = new Date();
        PointcutImpl pointcut = new PointcutImpl(new String[]{"compareTo"});
        AspectImpl aspect = new AspectImpl((MethodInterceptor)new TestInvocation(), (Pointcut)pointcut);
        AopProxy aopProxy = new AopProxy(Date.class, new Aspect[]{aspect});
        Date proxy = (Date)aopProxy.create();
        MyInvocationHandler handler = new MyInvocationHandler(target);
        Comparable proxy2 = (Comparable)Proxy.newProxyInstance(Date.class.getClassLoader(), new Class[]{Comparable.class}, (InvocationHandler)handler);
        int num = 2000000;
        long start = System.currentTimeMillis();
        for (i = 0; i < 2000000; ++i) {
            target.compareTo(target);
        }
        System.out.println("target:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        for (i = 0; i < 2000000; ++i) {
            proxy.compareTo(target);
        }
        System.out.println("AOP proxy:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        for (i = 0; i < 2000000; ++i) {
            proxy2.compareTo(target);
        }
        System.out.println("JDK proxy:" + (System.currentTimeMillis() - start));
    }

    public static class MyInvocationHandler
    implements InvocationHandler {
        private Object target;

        public MyInvocationHandler(Object target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke(this.target, args);
        }
    }

    public class HelloInterceptor
    implements MethodInterceptor {
        public Object invoke(MethodInvocation invocation) throws Throwable {
            return "Hello";
        }
    }

    public static class HelloImpl3
    implements Hello {
        private static final long serialVersionUID = 5992242320294594184L;

        public final String greeting() {
            return "hoge";
        }
    }

    public static class Hello2Impl
    implements Hello {
        private static final long serialVersionUID = -7275896388662514561L;

        public String greeting() {
            return "Hello2";
        }
    }

    public static class HelloImpl
    implements Hello {
        private static final long serialVersionUID = -6888891433122734807L;
        private String str_;

        public HelloImpl(String str) {
            this.str_ = str;
        }

        public String greeting() {
            return this.str_;
        }
    }

    public static interface Hello
    extends Serializable {
        public String greeting();
    }

    public class MyInvocation
    implements MethodInterceptor {
        public Object invoke(MethodInvocation invocation) throws Throwable {
            return invocation.proceed();
        }
    }

    public class TestInvocation
    implements MethodInterceptor {
        private boolean invoked_ = false;

        public Object invoke(MethodInvocation invocation) throws Throwable {
            this.invoked_ = true;
            return invocation.proceed();
        }
    }
}

