/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import java.util.Date;
import junit.framework.TestCase;
import org.seasar.framework.aop.interceptors.DelegateInterceptor;
import org.seasar.framework.exception.EmptyRuntimeException;

public class DelegateInterceptorTest
extends TestCase {
    public void testInvoke() throws Exception {
        HelloImpl target = new HelloImpl();
        DelegateInterceptor di = new DelegateInterceptor((Object)target);
        Hello proxy = (Hello)di.createProxy(Hello.class);
        DelegateInterceptorTest.assertEquals((String)"1", (String)"Hello", (String)proxy.greeting());
    }

    public void testInvoke2() throws Exception {
        Hello2Impl target = new Hello2Impl();
        DelegateInterceptor di = new DelegateInterceptor((Object)target);
        di.addMethodNameMap("greeting", "greeting2");
        Hello proxy = (Hello)di.createProxy(Hello.class);
        DelegateInterceptorTest.assertEquals((String)"1", (String)"Hello2", (String)proxy.greeting());
    }

    public void testInvoke3() throws Exception {
        DelegateInterceptor di = new DelegateInterceptor((Object)"hoge");
        Date proxy = (Date)di.createProxy(Date.class);
        DelegateInterceptorTest.assertTrue((String)"1", (proxy.getTime() > 0L ? 1 : 0) != 0);
    }

    public void testInvoke4() throws Exception {
        DelegateInterceptor di = new DelegateInterceptor((Object)new Date(0L));
        Date proxy = (Date)di.createProxy(Date.class);
        DelegateInterceptorTest.assertEquals((String)"1", (boolean)true, (proxy.getTime() != 0L ? 1 : 0) != 0);
    }

    public void testNullTarget() throws Exception {
        DelegateInterceptor di = new DelegateInterceptor();
        Hello proxy = (Hello)di.createProxy(Hello.class);
        try {
            proxy.greeting();
            DelegateInterceptorTest.fail((String)"1");
        }
        catch (EmptyRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public class Hello2Impl
    implements Hello2 {
        public String greeting2() {
            return "Hello2";
        }
    }

    public static interface Hello2 {
        public String greeting2();
    }

    public class HelloImpl
    implements Hello {
        public String greeting() {
            return "Hello";
        }
    }

    public static interface Hello {
        public String greeting();
    }
}

