/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.framework.util.DecimalFormatUtil;
import org.seasar.framework.util.StringUtil;

public class LongConversionUtil {
    protected LongConversionUtil() {
    }

    public static Long toLong(Object o) {
        return LongConversionUtil.toLong(o, null);
    }

    public static Long toLong(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Number) {
            return new Long(((Number)o).longValue());
        }
        if (o instanceof String) {
            return LongConversionUtil.toLong((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new Long(new SimpleDateFormat(pattern).format(o));
            }
            return new Long(((Date)o).getTime());
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? new Long(1L) : new Long(0L);
        }
        return LongConversionUtil.toLong(o.toString());
    }

    private static Long toLong(String s) {
        if (StringUtil.isEmpty(s)) {
            return null;
        }
        return new Long(DecimalFormatUtil.normalize(s));
    }

    public static long toPrimitiveLong(Object o) {
        return LongConversionUtil.toPrimitiveLong(o, null);
    }

    public static long toPrimitiveLong(Object o, String pattern) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof String) {
            return LongConversionUtil.toPrimitiveLong((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Long.parseLong(new SimpleDateFormat(pattern).format(o));
            }
            return ((Date)o).getTime();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1L : 0L;
        }
        return LongConversionUtil.toPrimitiveLong(o.toString());
    }

    private static long toPrimitiveLong(String s) {
        if (StringUtil.isEmpty(s)) {
            return 0L;
        }
        return Long.parseLong(DecimalFormatUtil.normalize(s));
    }
}

