/*
 * Copyright 2004-2014 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.extension.jdbc.gen.internal.exception;

import org.seasar.framework.exception.SRuntimeException;

/**
 * @author taedium
 * 
 */
public class NextVersionExceededRuntimeException extends SRuntimeException {

    private static final long serialVersionUID = 1L;

    /** DDL情報ファイルのパス */
    protected String ddlInfoFilePath;

    /**
     * インスタンスを構築します。
     * 
     * @param ddlInfoFilePath
     *            DDL情報ファイルのパス
     */
    public NextVersionExceededRuntimeException(String ddlInfoFilePath) {
        super("ES2JDBCGen0017", new Object[] { ddlInfoFilePath });
        this.ddlInfoFilePath = ddlInfoFilePath;
    }

    /**
     * DDL情報ファイルのパスを返します。
     * 
     * @return DDL情報ファイルのパス
     */
    public String getDdlInfoFilePath() {
        return ddlInfoFilePath;
    }

}
