/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.fs.PathInfo;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class FSFile {
    private File myFile;
    private FileChannel myChannel;
    private FileInputStream myInputStream;
    private long myPosition;
    private long myBufferPosition;
    private ByteBuffer myBuffer;
    private ByteBuffer myReadLineBuffer;
    private CharsetDecoder myDecoder;
    private MessageDigest myDigest;

    public FSFile(File file) {
        this.myFile = file;
        this.myPosition = 0L;
        this.myBufferPosition = 0L;
        this.myBuffer = ByteBuffer.allocate(1024);
        this.myReadLineBuffer = ByteBuffer.allocate(1024);
        this.myDecoder = Charset.forName("UTF-8").newDecoder();
        this.myDecoder = this.myDecoder.onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    public void seek(long position) {
        this.myPosition = position;
    }

    public long position() {
        return this.myPosition;
    }

    public long size() {
        return this.myFile.length();
    }

    public void resetDigest() {
        if (this.myDigest == null) {
            try {
                this.myDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        this.myDigest.reset();
    }

    public String digest() {
        String digest = SVNFileUtil.toHexDigest(this.myDigest);
        this.myDigest = null;
        return digest;
    }

    public int readInt() throws SVNException, NumberFormatException {
        String line = this.readLine(80);
        if (line == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "First line of ''{0}'' contains non-digit", this.myFile);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        return Integer.parseInt(line);
    }

    public long readLong() throws SVNException, NumberFormatException {
        String line = this.readLine(80);
        if (line == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "First line of ''{0}'' contains non-digit", this.myFile);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        return Long.parseLong(line);
    }

    public String readLine(int limit) throws SVNException {
        this.allocateReadBuffer(limit);
        try {
            while (this.myReadLineBuffer.hasRemaining()) {
                int b = this.read();
                if (b < 0) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.STREAM_UNEXPECTED_EOF, "Can''t read length line from file {0}", this.getFile());
                    SVNErrorManager.error(err, SVNLogType.DEFAULT);
                } else if (b == 10) break;
                this.myReadLineBuffer.put((byte)(b & 0xFF));
            }
            this.myReadLineBuffer.flip();
            return this.myDecoder.decode(this.myReadLineBuffer).toString();
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Can''t read length line from file {0}: {1}", new Object[]{this.getFile(), e.getLocalizedMessage()});
            SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
            return null;
        }
    }

    public String readLine(StringBuffer buffer) throws SVNException {
        if (buffer == null) {
            buffer = new StringBuffer();
        }
        boolean endOfLineMet = false;
        boolean lineStart = true;
        try {
            while (!endOfLineMet) {
                this.allocateReadBuffer(160);
                while (this.myReadLineBuffer.hasRemaining()) {
                    int b = this.read();
                    if (b < 0) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.STREAM_UNEXPECTED_EOF, "Can''t read length line from file {0}", this.getFile());
                        SVNErrorManager.error(err, lineStart ? Level.FINEST : Level.FINE, SVNLogType.DEFAULT);
                    } else if (b == 10) {
                        endOfLineMet = true;
                        break;
                    }
                    this.myReadLineBuffer.put((byte)(b & 0xFF));
                    lineStart = false;
                }
                this.myReadLineBuffer.flip();
                buffer.append(this.myDecoder.decode(this.myReadLineBuffer).toString());
            }
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Can''t read length line from file {0}: {1}", new Object[]{this.getFile(), e.getLocalizedMessage()});
            SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
        }
        return buffer.toString();
    }

    public SVNProperties readProperties(boolean allowEOF, boolean allowBinaryValues) throws SVNException {
        SVNProperties properties = new SVNProperties();
        String line = null;
        block12: while (true) {
            try {
                while (true) {
                    SVNErrorMessage err;
                    SVNErrorMessage err2;
                    try {
                        line = this.readLine(160);
                    }
                    catch (SVNException e) {
                        if (allowEOF && e.getErrorMessage().getErrorCode() == SVNErrorCode.STREAM_UNEXPECTED_EOF) break block12;
                        SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.MALFORMED_FILE);
                        SVNErrorManager.error(err3, e, SVNLogType.DEFAULT);
                    }
                    if (line == null || "".equals(line) || !allowEOF && "END".equals(line)) break block12;
                    char kind = line.charAt(0);
                    int length = -1;
                    if (kind != 'K' && kind != 'D' || line.length() < 3 || line.charAt(1) != ' ' || line.length() < 3) {
                        err2 = SVNErrorMessage.create(SVNErrorCode.MALFORMED_FILE);
                        SVNErrorManager.error(err2, SVNLogType.DEFAULT);
                    }
                    try {
                        length = Integer.parseInt(line.substring(2));
                    }
                    catch (NumberFormatException nfe) {
                        SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.MALFORMED_FILE);
                        SVNErrorManager.error(err4, SVNLogType.DEFAULT);
                    }
                    if (length < 0) {
                        err2 = SVNErrorMessage.create(SVNErrorCode.MALFORMED_FILE);
                        SVNErrorManager.error(err2, SVNLogType.DEFAULT);
                    }
                    this.allocateReadBuffer(length + 1);
                    this.read(this.myReadLineBuffer);
                    this.myReadLineBuffer.flip();
                    this.myReadLineBuffer.limit(this.myReadLineBuffer.limit() - 1);
                    int pos = this.myReadLineBuffer.position();
                    int limit = this.myReadLineBuffer.limit();
                    String key = null;
                    try {
                        key = this.myDecoder.decode(this.myReadLineBuffer).toString();
                    }
                    catch (MalformedInputException mfi) {
                        key = new String(this.myReadLineBuffer.array(), this.myReadLineBuffer.arrayOffset() + pos, limit - pos);
                    }
                    if (kind == 'D') {
                        properties.put(key, (SVNPropertyValue)null);
                        continue;
                    }
                    line = this.readLine(160);
                    if (line == null || line.length() < 3 || line.charAt(0) != 'V' || line.charAt(1) != ' ') {
                        err = SVNErrorMessage.create(SVNErrorCode.MALFORMED_FILE);
                        SVNErrorManager.error(err, SVNLogType.DEFAULT);
                    }
                    try {
                        length = Integer.parseInt(line.substring(2));
                    }
                    catch (NumberFormatException nfe) {
                        SVNErrorMessage err5 = SVNErrorMessage.create(SVNErrorCode.MALFORMED_FILE);
                        SVNErrorManager.error(err5, SVNLogType.DEFAULT);
                    }
                    if (length < 0) {
                        err = SVNErrorMessage.create(SVNErrorCode.MALFORMED_FILE);
                        SVNErrorManager.error(err, SVNLogType.DEFAULT);
                    }
                    this.allocateReadBuffer(length + 1);
                    this.read(this.myReadLineBuffer);
                    this.myReadLineBuffer.flip();
                    this.myReadLineBuffer.limit(this.myReadLineBuffer.limit() - 1);
                    pos = this.myReadLineBuffer.position();
                    limit = this.myReadLineBuffer.limit();
                    try {
                        properties.put(key, this.myDecoder.decode(this.myReadLineBuffer).toString());
                        continue block12;
                    }
                    catch (CharacterCodingException cce) {
                        if (allowBinaryValues) {
                            byte[] dst = new byte[limit - pos];
                            this.myReadLineBuffer.position(pos);
                            this.myReadLineBuffer.get(dst);
                            properties.put(key, dst);
                            continue;
                        }
                        SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "File ''{0}'' contains unexpected binary property value", this.getFile());
                        SVNErrorManager.error(error, cce, SVNLogType.DEFAULT);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.MALFORMED_FILE);
                SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
                break;
            }
        }
        return properties;
    }

    public Map readHeader() throws SVNException {
        String line;
        SVNHashMap map = new SVNHashMap();
        while (!"".equals(line = this.readLine(1024))) {
            SVNErrorMessage err;
            int colonIndex = line.indexOf(58);
            if (colonIndex <= 0 || line.length() <= colonIndex + 2) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, line);
                err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Found malformed header in revision file");
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            } else if (line.charAt(colonIndex + 1) != ' ') {
                err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Found malformed header in revision file");
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            String key = line.substring(0, colonIndex);
            String value = line.substring(colonIndex + 2);
            map.put(key, value);
        }
        return map;
    }

    public int read() throws IOException {
        if (this.myChannel == null || this.myPosition < this.myBufferPosition || this.myPosition >= this.myBufferPosition + (long)this.myBuffer.limit()) {
            if (this.fill() <= 0) {
                return -1;
            }
        } else {
            this.myBuffer.position((int)(this.myPosition - this.myBufferPosition));
        }
        int r = this.myBuffer.get() & 0xFF;
        if (this.myDigest != null) {
            this.myDigest.update((byte)r);
        }
        ++this.myPosition;
        return r;
    }

    public int read(ByteBuffer target) throws IOException {
        int read = 0;
        while (target.hasRemaining()) {
            if (this.fill() < 0) {
                return read > 0 ? read : -1;
            }
            this.myBuffer.position((int)(this.myPosition - this.myBufferPosition));
            int couldRead = Math.min(this.myBuffer.remaining(), target.remaining());
            int readFrom = this.myBuffer.position() + this.myBuffer.arrayOffset();
            target.put(this.myBuffer.array(), readFrom, couldRead);
            if (this.myDigest != null) {
                this.myDigest.update(this.myBuffer.array(), readFrom, couldRead);
            }
            this.myPosition += (long)couldRead;
            read += couldRead;
            this.myBuffer.position(this.myBuffer.position() + couldRead);
        }
        return read;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int read = 0;
        int toRead = length;
        while (toRead > 0) {
            if (this.fill() < 0) {
                return read > 0 ? read : -1;
            }
            this.myBuffer.position((int)(this.myPosition - this.myBufferPosition));
            int couldRead = Math.min(this.myBuffer.remaining(), toRead);
            this.myBuffer.get(buffer, offset, couldRead);
            if (this.myDigest != null) {
                this.myDigest.update(buffer, offset, couldRead);
            }
            toRead -= couldRead;
            offset += couldRead;
            this.myPosition += (long)couldRead;
            read += couldRead;
        }
        return read;
    }

    public File getFile() {
        return this.myFile;
    }

    public void close() {
        if (this.myChannel != null) {
            try {
                this.myChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            SVNFileUtil.closeFile(this.myInputStream);
            this.myChannel = null;
            this.myInputStream = null;
            this.myPosition = 0L;
            this.myDigest = null;
        }
    }

    private int fill() throws IOException {
        if (this.myChannel == null || this.myPosition < this.myBufferPosition || this.myPosition >= this.myBufferPosition + (long)this.myBuffer.limit()) {
            this.myBufferPosition = this.myPosition;
            this.getChannel().position(this.myBufferPosition);
            this.myBuffer.clear();
            int read = this.getChannel().read(this.myBuffer);
            this.myBuffer.position(0);
            this.myBuffer.limit(read >= 0 ? read : 0);
            return read;
        }
        return 0;
    }

    private void allocateReadBuffer(int limit) {
        if (limit > this.myReadLineBuffer.capacity()) {
            this.myReadLineBuffer = ByteBuffer.allocate(limit * 3 / 2);
        }
        this.myReadLineBuffer.clear();
        this.myReadLineBuffer.limit(limit);
    }

    private FileChannel getChannel() throws IOException {
        if (this.myChannel == null) {
            this.myInputStream = SVNFileUtil.createFileInputStream(this.myFile);
            this.myChannel = this.myInputStream.getChannel();
        }
        return this.myChannel;
    }

    public PathInfo readPathInfoFromReportFile() throws IOException, SVNException {
        int firstByte = this.read();
        if (firstByte == -1 || firstByte == 45) {
            return null;
        }
        String path = this.readStringFromReportFile();
        String linkPath = this.read() == 43 ? this.readStringFromReportFile() : null;
        long revision = this.readRevisionFromReportFile();
        SVNDepth depth = SVNDepth.INFINITY;
        if (this.read() == 43) {
            int id = this.read();
            switch (id) {
                case 88: {
                    depth = SVNDepth.EXCLUDE;
                    break;
                }
                case 69: {
                    depth = SVNDepth.EMPTY;
                    break;
                }
                case 70: {
                    depth = SVNDepth.FILES;
                    break;
                }
                case 77: {
                    depth = SVNDepth.IMMEDIATES;
                    break;
                }
                default: {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_REVISION_REPORT, "Invalid depth ({0}) for path ''{1}''", new Object[]{new Integer(id), path});
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
        }
        boolean startEmpty = this.read() == 43;
        String lockToken = this.read() == 43 ? this.readStringFromReportFile() : null;
        return new PathInfo(path, linkPath, lockToken, revision, depth, startEmpty);
    }

    private String readStringFromReportFile() throws IOException {
        int length = this.readNumberFromReportFile();
        if (length == 0) {
            return "";
        }
        byte[] buffer = new byte[length];
        this.read(buffer, 0, length);
        return new String(buffer, "UTF-8");
    }

    private int readNumberFromReportFile() throws IOException {
        int b;
        ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
        while ((b = this.read()) != 58) {
            resultStream.write(b);
        }
        return Integer.parseInt(new String(resultStream.toByteArray(), "UTF-8"), 10);
    }

    private long readRevisionFromReportFile() throws IOException {
        if (this.read() == 43) {
            return this.readNumberFromReportFile();
        }
        return -1L;
    }
}

