/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.external;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import junit.framework.TestCase;
import org.seasar.framework.container.external.AbstractExternalContextMap;
import org.seasar.framework.mock.servlet.MockServletContext;
import org.seasar.framework.mock.servlet.MockServletContextImpl;
import org.seasar.framework.util.EnumerationIterator;

public class AbstExternalContextMapTest
extends TestCase {
    private MockServletContext context;

    protected void setUp() throws Exception {
        this.context = new MockServletContextImpl(null);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGet() {
        ExternalContextMap map = new ExternalContextMap((ServletContext)this.context);
        map.put("a", "A");
        AbstExternalContextMapTest.assertEquals((Object)"A", (Object)map.get("a"));
    }

    public void testPutAll() {
        ExternalContextMap map = new ExternalContextMap((ServletContext)this.context);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("a", "A");
        m.put("b", "B");
        map.putAll(m);
        AbstExternalContextMapTest.assertEquals((Object)"A", (Object)map.get("a"));
        AbstExternalContextMapTest.assertEquals((Object)"B", (Object)map.get("b"));
    }

    public void testIsEmpty() {
        ExternalContextMap map = new ExternalContextMap((ServletContext)this.context);
        AbstExternalContextMapTest.assertTrue((boolean)map.isEmpty());
        map.put("a", "A");
        AbstExternalContextMapTest.assertFalse((boolean)map.isEmpty());
    }

    public void testClear() {
        ExternalContextMap map = new ExternalContextMap((ServletContext)this.context);
        map.put("c", "C");
        map.put("d", "D");
        AbstExternalContextMapTest.assertNotNull((Object)map.get("c"));
        map.clear();
        AbstExternalContextMapTest.assertNull((Object)map.get("c"));
    }

    public void testContainsKey() {
        ExternalContextMap map = new ExternalContextMap((ServletContext)this.context);
        map.put("e", "E");
        AbstExternalContextMapTest.assertTrue((boolean)map.containsKey("e"));
        AbstExternalContextMapTest.assertFalse((boolean)map.containsKey("not_a_key"));
    }

    public void testContainsValue() {
        ExternalContextMap map = new ExternalContextMap((ServletContext)this.context);
        map.put("f", "F");
        map.put("g", "F");
        map.put("h", "H");
        AbstExternalContextMapTest.assertTrue((boolean)map.containsValue("F"));
        AbstExternalContextMapTest.assertFalse((boolean)map.containsValue("not_a_value"));
    }

    public void testEntrySet() {
        ExternalContextMap map = new ExternalContextMap((ServletContext)this.context);
        map.put("a", "A");
        map.put("b", "B");
        Iterator itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            AbstExternalContextMapTest.assertNotNull(o);
            AbstExternalContextMapTest.assertTrue((boolean)(o instanceof Map.Entry));
        }
    }

    public void testKeySet() {
        this.context.setAttribute("a", (Object)"A");
        this.context.setAttribute("b", (Object)"B");
        ExternalContextMap map = new ExternalContextMap((ServletContext)this.context);
        Iterator itr = map.keySet().iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            AbstExternalContextMapTest.assertNotNull(o);
            AbstExternalContextMapTest.assertTrue((boolean)(o instanceof String));
        }
    }

    public void testRemove() {
        this.context.setAttribute("i", (Object)"I");
        ExternalContextMap map = new ExternalContextMap((ServletContext)this.context);
        String s = (String)map.get("i");
        AbstExternalContextMapTest.assertNotNull((Object)s);
        map.remove("i");
        AbstExternalContextMapTest.assertNull((Object)map.get("i"));
    }

    public void testValues() {
        this.context.setAttribute("j", (Object)"1");
        this.context.setAttribute("k", (Object)"2");
        this.context.setAttribute("l", (Object)"3");
        ExternalContextMap map = new ExternalContextMap((ServletContext)this.context);
        Collection c = map.values();
        AbstExternalContextMapTest.assertEquals((int)3, (int)c.size());
        AbstExternalContextMapTest.assertTrue((boolean)c.contains("1"));
        AbstExternalContextMapTest.assertTrue((boolean)c.contains("2"));
        AbstExternalContextMapTest.assertTrue((boolean)c.contains("3"));
    }

    private static class ExternalContextMap
    extends AbstractExternalContextMap {
        private ServletContext context_;

        public ExternalContextMap(ServletContext context) {
            this.context_ = context;
        }

        protected Object getAttribute(String key) {
            return this.context_.getAttribute(key);
        }

        protected void setAttribute(String key, Object value) {
            this.context_.setAttribute(key, value);
        }

        protected Iterator getAttributeNames() {
            return new EnumerationIterator(this.context_.getAttributeNames());
        }

        protected void removeAttribute(String key) {
            this.context_.removeAttribute(key);
        }
    }
}

