/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.customizer;

import junit.framework.TestCase;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.customizer.AbstractCustomizer;
import org.seasar.framework.container.impl.ComponentDefImpl;

public class AbstCustomizerTest
extends TestCase {
    private boolean matched;

    public void testNoPattern() throws Exception {
        TestCustomizer customizer = new TestCustomizer();
        this.matched = false;
        customizer.customize((ComponentDef)new ComponentDefImpl(Foo.class));
        AbstCustomizerTest.assertTrue((boolean)this.matched);
        this.matched = false;
        customizer.customize((ComponentDef)new ComponentDefImpl(Bar.class));
        AbstCustomizerTest.assertTrue((boolean)this.matched);
        this.matched = false;
        customizer.customize((ComponentDef)new ComponentDefImpl(Baz.class));
        AbstCustomizerTest.assertTrue((boolean)this.matched);
    }

    public void testApplyOnly() throws Exception {
        TestCustomizer customizer = new TestCustomizer();
        customizer.addClassPattern("org.seasar.framework.container.customizer", "AbstCustomizerTest\\$B.*");
        this.matched = false;
        customizer.customize((ComponentDef)new ComponentDefImpl(Foo.class));
        AbstCustomizerTest.assertFalse((boolean)this.matched);
        this.matched = false;
        customizer.customize((ComponentDef)new ComponentDefImpl(Bar.class));
        AbstCustomizerTest.assertTrue((boolean)this.matched);
        this.matched = false;
        customizer.customize((ComponentDef)new ComponentDefImpl(Baz.class));
        AbstCustomizerTest.assertTrue((boolean)this.matched);
    }

    public void testIgnoreOnly() throws Exception {
        TestCustomizer customizer = new TestCustomizer();
        customizer.addIgnoreClassPattern("org.seasar.framework.container.customizer", "AbstCustomizerTest\\$B.*");
        this.matched = false;
        customizer.customize((ComponentDef)new ComponentDefImpl(Foo.class));
        AbstCustomizerTest.assertTrue((boolean)this.matched);
        this.matched = false;
        customizer.customize((ComponentDef)new ComponentDefImpl(Bar.class));
        AbstCustomizerTest.assertFalse((boolean)this.matched);
        this.matched = false;
        customizer.customize((ComponentDef)new ComponentDefImpl(Baz.class));
        AbstCustomizerTest.assertFalse((boolean)this.matched);
    }

    public void testApplyIgnore() throws Exception {
        TestCustomizer customizer = new TestCustomizer();
        customizer.addClassPattern("org.seasar.framework.container.customizer", "AbstCustomizerTest\\$B.*");
        customizer.addIgnoreClassPattern("org.seasar.framework.container.customizer", ".*z");
        this.matched = false;
        customizer.customize((ComponentDef)new ComponentDefImpl(Foo.class));
        AbstCustomizerTest.assertFalse((boolean)this.matched);
        this.matched = false;
        customizer.customize((ComponentDef)new ComponentDefImpl(Bar.class));
        AbstCustomizerTest.assertTrue((boolean)this.matched);
        this.matched = false;
        customizer.customize((ComponentDef)new ComponentDefImpl(Baz.class));
        AbstCustomizerTest.assertFalse((boolean)this.matched);
    }

    public void testTargetInterface() throws Exception {
        TestCustomizer customizer = new TestCustomizer();
        customizer.setTargetInterface(Super.class);
        this.matched = false;
        customizer.customize((ComponentDef)new ComponentDefImpl(Foo.class));
        AbstCustomizerTest.assertTrue((boolean)this.matched);
        this.matched = false;
        customizer.customize((ComponentDef)new ComponentDefImpl(Bar.class));
        AbstCustomizerTest.assertTrue((boolean)this.matched);
        this.matched = false;
        customizer.customize((ComponentDef)new ComponentDefImpl(Baz.class));
        AbstCustomizerTest.assertFalse((boolean)this.matched);
    }

    public static class Baz {
    }

    public static class Bar
    implements Sub {
    }

    public static class Foo
    implements Super {
    }

    public static interface Sub
    extends Super {
    }

    public static interface Super {
    }

    public class TestCustomizer
    extends AbstractCustomizer {
        protected void doCustomize(ComponentDef componentDef) {
            System.out.println(componentDef.getComponentClass().getName());
            AbstCustomizerTest.this.matched = true;
        }
    }
}

