/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import junit.framework.TestCase;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.assembler.AccessTypeDefFactory;
import org.seasar.framework.container.impl.PropertyDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;

public class AccessTypeFieldTest
extends TestCase {
    public void test() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        container.register(FooImpl.class, "foo");
        container.register(Bar.class, "bar");
        ComponentDef cd1 = container.getComponentDef((Object)"bar");
        PropertyDefImpl pd1 = new PropertyDefImpl("foo");
        pd1.setAccessTypeDef(AccessTypeDefFactory.FIELD);
        cd1.addPropertyDef((PropertyDef)pd1);
        container.register(Baz.class, "baz");
        ComponentDef cd2 = container.getComponentDef((Object)"baz");
        PropertyDefImpl pd2 = new PropertyDefImpl("foo");
        pd2.setAccessTypeDef(AccessTypeDefFactory.FIELD);
        cd2.addPropertyDef((PropertyDef)pd2);
        container.init();
        Foo foo = (Foo)container.getComponent((Object)"foo");
        Bar bar = (Bar)container.getComponent((Object)"bar");
        Baz baz = (Baz)container.getComponent((Object)"baz");
        AccessTypeFieldTest.assertEquals((Object)foo, (Object)bar.foo);
        AccessTypeFieldTest.assertEquals((Object)foo, (Object)baz.getFoo());
    }

    public static class Baz {
        private Foo foo;

        public Foo getFoo() {
            return this.foo;
        }

        public void setFoo(Foo foo) {
            throw new RuntimeException();
        }
    }

    public static class Bar {
        private Foo foo;
    }

    public static class FooImpl
    implements Foo {
    }

    public static interface Foo {
    }
}

