/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.model;

import java.io.File;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import org.seasar.extension.jdbc.gen.internal.model.ClassModelSupport;
import org.seasar.extension.jdbc.gen.internal.model.GeneratedModelSupport;
import org.seasar.extension.jdbc.gen.internal.model.SqlFileSupport;
import org.seasar.extension.jdbc.gen.model.ClassModel;
import org.seasar.extension.jdbc.gen.model.SqlFileConstantFieldModel;
import org.seasar.extension.jdbc.gen.model.SqlFileConstantNamingRule;
import org.seasar.extension.jdbc.gen.model.SqlFileConstantsModel;
import org.seasar.extension.jdbc.gen.model.SqlFileConstantsModelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlFileConstantsModelFactoryImpl
implements SqlFileConstantsModelFactory {
    protected SqlFileConstantNamingRule sqlFileConstantNamingRule;
    protected String packageName;
    protected String shortClassName;
    protected List<String> sqlFilePathList;
    protected GeneratedModelSupport generatedModelSupport = new GeneratedModelSupport();
    protected ClassModelSupport classModelSupport = new ClassModelSupport();
    protected SqlFileSupport sqlFileSupport = new SqlFileSupport();

    public SqlFileConstantsModelFactoryImpl(File classpathDir, Set<File> sqlFileSet, SqlFileConstantNamingRule sqlFileConstantNamingRule, String packageName, String shortClassName) {
        if (classpathDir == null) {
            throw new NullPointerException("classpathDir");
        }
        if (sqlFileSet == null) {
            throw new NullPointerException("sqlFileSet");
        }
        if (sqlFileConstantNamingRule == null) {
            throw new NullPointerException("sqlFileConstantNamingRule");
        }
        if (shortClassName == null) {
            throw new NullPointerException("shortClassName");
        }
        this.sqlFileConstantNamingRule = sqlFileConstantNamingRule;
        this.packageName = packageName;
        this.shortClassName = shortClassName;
        this.sqlFilePathList = this.createSqlFilePathList(classpathDir, sqlFileSet);
    }

    protected List<String> createSqlFilePathList(File classpathDir, Set<File> sqlFileSet) {
        return this.sqlFileSupport.createSqlFilePathList(classpathDir, sqlFileSet);
    }

    @Override
    public SqlFileConstantsModel getSqlFileConstantsModel() {
        SqlFileConstantsModel model = new SqlFileConstantsModel();
        model.setPackageName(this.packageName);
        model.setShortClassName(this.shortClassName);
        for (String path : this.sqlFilePathList) {
            SqlFileConstantFieldModel fieldModel = this.createSqlFileConstantFieldModel(path);
            model.addSqlFileConstantFieldModel(fieldModel);
        }
        this.doGeneratedInfo(model);
        this.doImportName(model);
        return model;
    }

    protected SqlFileConstantFieldModel createSqlFileConstantFieldModel(String path) {
        SqlFileConstantFieldModel fieldModel = new SqlFileConstantFieldModel();
        fieldModel.setName(this.sqlFileConstantNamingRule.fromPathToConstantName(path));
        fieldModel.setPath(path);
        return fieldModel;
    }

    protected void doImportName(SqlFileConstantsModel sqlFileConstantsModel) {
        this.classModelSupport.addImportName((ClassModel)sqlFileConstantsModel, Generated.class);
    }

    protected void doGeneratedInfo(SqlFileConstantsModel sqlFileConstantsModel) {
        this.generatedModelSupport.fillGeneratedInfo(this, sqlFileConstantsModel);
    }
}

