/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.httpsession;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.seasar.framework.util.StringUtil;

public class SessionIdUtil {
    public static final String SESSION_ID_KEY = "S2SESSIONID";
    static String cookieName = "S2SESSIONID";
    static int cookieMaxAge = -1;
    static String cookiePath = null;
    static Boolean cookieSecure = null;

    public static String getSessionIdFromCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (!cookie.getName().equals(cookieName)) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static String getSessionIdFromURL(HttpServletRequest request) {
        String partOfUri = ";" + cookieName + "=";
        String uri = request.getRequestURI();
        int index = uri.lastIndexOf(partOfUri);
        if (index < 0) {
            return null;
        }
        int index2 = (uri = uri.substring(index + partOfUri.length())).indexOf(63);
        if (index2 < 0) {
            return uri;
        }
        return uri.substring(0, index2);
    }

    public static String rewriteURL(String url, HttpServletRequest request) {
        if (request.isRequestedSessionIdFromCookie()) {
            return url;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            return url;
        }
        String partOfUri = ";" + cookieName + "=";
        int index = url.indexOf(63);
        if (index < 0) {
            return url + partOfUri + session.getId();
        }
        return url.substring(0, index) + partOfUri + session.getId() + url.substring(index);
    }

    public static void writeCookie(HttpServletRequest request, HttpServletResponse response, String sessionId) {
        if (request.isRequestedSessionIdFromCookie()) {
            return;
        }
        Cookie cookie = new Cookie(cookieName, sessionId);
        if (StringUtil.isNotEmpty((String)cookiePath)) {
            cookie.setPath(cookiePath);
        } else {
            String path = request.getContextPath();
            cookie.setPath(StringUtil.isEmpty((String)path) ? "/" : path);
        }
        cookie.setMaxAge(cookieMaxAge);
        if (cookieSecure != null) {
            cookie.setSecure(cookieSecure.booleanValue());
        }
        response.addCookie(cookie);
    }
}

