/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.Driver;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.StringUtils;
import org.h2.util.Tool;

public class Script
extends Tool {
    private void showUsage() {
        this.out.println("Allows converting a database to a SQL script.");
        this.out.println("java " + this.getClass().getName() + "\n" + " -url <url>         The database URL\n" + " -user <user>       The user name\n" + " [-password <pwd>]  The password\n" + " [-script <file>]   The script file to run (default: backup.sql)\n" + " [-quiet]           Do not print progress information\n" + " [-options ...]     The list of options (only for H2 embedded mode)");
        this.out.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    public static void main(String[] stringArray) throws SQLException {
        new Script().run(stringArray);
    }

    public void run(String[] stringArray) throws SQLException {
        String string = null;
        String string2 = null;
        String string3 = "";
        String string4 = "backup.sql";
        String string5 = null;
        String string6 = null;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string7 = stringArray[i];
            if (string7.equals("-url")) {
                string = stringArray[++i];
                continue;
            }
            if (string7.equals("-user")) {
                string2 = stringArray[++i];
                continue;
            }
            if (string7.equals("-password")) {
                string3 = stringArray[++i];
                continue;
            }
            if (string7.equals("-script")) {
                string4 = stringArray[++i];
                continue;
            }
            if (string7.equals("-options")) {
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                ++i;
                while (i < stringArray.length) {
                    String string8 = stringArray[i];
                    String string9 = StringUtils.toUpperEnglish(string8);
                    if (string9.startsWith("NO") || "DROP".equals(string9)) {
                        stringBuffer.append(' ');
                        stringBuffer.append(stringArray[i]);
                    } else {
                        stringBuffer2.append(' ');
                        stringBuffer2.append(stringArray[i]);
                    }
                    ++i;
                }
                string5 = stringBuffer.toString();
                string6 = stringBuffer2.toString();
                continue;
            }
            if (string7.equals("-help") || string7.equals("-?")) {
                this.showUsage();
                return;
            }
            this.out.println("Unsupported option: " + string7);
            this.showUsage();
            return;
        }
        if (string == null || string2 == null || string4 == null) {
            this.showUsage();
            return;
        }
        if (string5 != null) {
            this.processScript(string, string2, string3, string4, string5, string6);
        } else {
            this.process(string, string2, string3, string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processScript(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        Connection connection = null;
        Statement statement = null;
        try {
            Driver.load();
            connection = DriverManager.getConnection(string, string2, string3);
            statement = connection.createStatement();
            String string7 = "SCRIPT " + string5 + " TO '" + string4 + "' " + string6;
            statement.execute(string7);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(statement);
            JdbcUtils.closeSilently(connection);
            throw throwable;
        }
        JdbcUtils.closeSilently(statement);
        JdbcUtils.closeSilently(connection);
    }

    public static void execute(String string, String string2, String string3, String string4) throws SQLException {
        new Script().process(string, string2, string3, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process(String string, String string2, String string3, String string4) throws SQLException {
        Connection connection = null;
        Statement statement = null;
        Writer writer = null;
        try {
            Driver.load();
            connection = DriverManager.getConnection(string, string2, string3);
            statement = connection.createStatement();
            writer = IOUtils.getWriter(FileUtils.openFileOutputStream(string4, false));
            PrintWriter printWriter = new PrintWriter(writer);
            ResultSet resultSet = statement.executeQuery("SCRIPT");
            while (resultSet.next()) {
                String string5 = resultSet.getString(1);
                printWriter.println(string5);
            }
            printWriter.close();
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(statement);
            JdbcUtils.closeSilently(connection);
            IOUtils.closeSilently(writer);
            throw throwable;
        }
        JdbcUtils.closeSilently(statement);
        JdbcUtils.closeSilently(connection);
        IOUtils.closeSilently(writer);
    }
}

