/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.sqltype;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.gen.internal.sqltype.AbstractSqlType;
import org.seasar.framework.util.Base64Util;

public class BinaryType
extends AbstractSqlType {
    protected static byte[] EMPTY_BYTES = new byte[0];

    public BinaryType() {
        this("binary");
    }

    public BinaryType(String dataType) {
        super(dataType);
    }

    public void bindValue(PreparedStatement ps, int index, String value) throws SQLException {
        if (value == null) {
            ps.setNull(index, -2);
        } else if (value.length() == 0) {
            ps.setBytes(index, EMPTY_BYTES);
        } else {
            ps.setBytes(index, Base64Util.decode((String)value));
        }
    }

    public String getValue(ResultSet resultSet, int index) throws SQLException {
        byte[] value = resultSet.getBytes(index);
        return value != null ? Base64Util.encode((byte[])value) : null;
    }
}

