/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.extension.svn;

import java.io.File;
import java.util.Collection;
import java.util.TreeSet;
import org.seasar.extension.jdbc.gen.event.GenDdlEvent;
import org.seasar.extension.jdbc.gen.event.GenDdlListener;
import org.seasar.extension.jdbc.gen.extension.svn.SvnRuntimeException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class GenDdlSvnProcessor
implements GenDdlListener {
    protected SVNClientManager clientManager = SVNClientManager.newInstance();
    protected SVNWCClient wcClient = this.clientManager.getWCClient();
    protected SVNStatusClient statusClient = this.clientManager.getStatusClient();
    protected SVNCopyClient copyClient = this.clientManager.getCopyClient();
    protected File currentVersionDir;
    protected File nextVersionDir;
    protected File migrateDir;
    protected boolean underSvn;

    public GenDdlSvnProcessor() {
    }

    public GenDdlSvnProcessor(final int version) {
        SVNAdminAreaFactory.setSelector((ISVNAdminAreaFactorySelector)new ISVNAdminAreaFactorySelector(){

            public Collection getEnabledFactories(File path, Collection factories, boolean writeAccess) throws SVNException {
                TreeSet<SVNAdminAreaFactory> enabledFactories = new TreeSet<SVNAdminAreaFactory>();
                for (SVNAdminAreaFactory factory : factories) {
                    if (version != factory.getSupportedVersion()) continue;
                    enabledFactories.add(factory);
                }
                return enabledFactories;
            }
        });
    }

    public void preCreateNextVersionDir(GenDdlEvent event) {
    }

    public void postCreateNextVersionDir(GenDdlEvent event) {
        try {
            this.currentVersionDir = event.getCurrentVersionDir().asFile();
            this.nextVersionDir = event.getNextVersionDir().asFile();
            this.migrateDir = this.nextVersionDir.getParentFile();
            boolean bl = this.underSvn = this.underSvn(this.migrateDir) && this.underSvn(this.currentVersionDir);
            if (!this.underSvn) {
                return;
            }
            this.wcClient.doAdd(this.nextVersionDir, false, false, false, null, false, false);
        }
        catch (SVNException e) {
            throw new SvnRuntimeException(e);
        }
    }

    public void preRemoveNextVersionDir(GenDdlEvent event) {
        try {
            if (!this.underSvn) {
                return;
            }
            this.wcClient.doDelete(this.nextVersionDir, true, false, false);
        }
        catch (SVNException e) {
            throw new SvnRuntimeException(e);
        }
    }

    public void postRemoveNextVersionDir(GenDdlEvent event) {
    }

    public void preCreateTargetFile(GenDdlEvent event) {
        try {
            if (!this.underSvn) {
                return;
            }
            File currentFile = new File(this.currentVersionDir, event.getTargetFile());
            File parentFile = currentFile.getParentFile();
            if (!currentFile.exists() || currentFile.isDirectory() || !this.underSvn(currentFile) || !this.underSvn(parentFile)) {
                return;
            }
            SVNCopySource source = new SVNCopySource(SVNRevision.WORKING, SVNRevision.WORKING, currentFile);
            File nextFile = new File(this.nextVersionDir, event.getTargetFile());
            this.copyClient.doCopy(new SVNCopySource[]{source}, nextFile, false, false, true);
        }
        catch (SVNException e) {
            throw new SvnRuntimeException(e);
        }
    }

    public void postCreateTargetFile(GenDdlEvent event) {
        try {
            if (!this.underSvn) {
                return;
            }
            File createdFile = new File(this.nextVersionDir, event.getTargetFile());
            if (!createdFile.isDirectory()) {
                return;
            }
            this.wcClient.doAdd(createdFile, false, false, false, null, false, false);
        }
        catch (SVNException e) {
            throw new SvnRuntimeException(e);
        }
    }

    protected boolean underSvn(File file) {
        try {
            SVNStatus status = this.statusClient.doStatus(file, false);
            return status != null && status.getContentsStatus() != SVNStatusType.STATUS_UNVERSIONED;
        }
        catch (SVNException e) {
            return false;
        }
    }

    static {
        SVNAdminAreaFactory.setUpgradeEnabled((boolean)false);
    }
}

